/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.support;

import com.baidu.aip.face.AipFace;
import com.baidu.aip.face.MatchRequest;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.openocr.AbstractFaceRecognize;
import com.walker.openocr.FaceDetectResult;
import com.walker.openocr.util.FaceItem;
import com.walker.openocr.util.FaceUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class BaiduFaceRecognize
extends AbstractFaceRecognize {
    private String appId;
    private String apiKey;
    private String secretKey;
    private AipFace client;

    @Override
    public FaceDetectResult detect(String image, String imageType, Object option) {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4eba\u8138\u68c0\u6d4b\u63a5\u53e3");
    }

    @Override
    public double matchTwoFace(FaceItem face1, FaceItem face2) {
        this.logger.debug(face1.getFaceToken() + ", " + face2.getFaceToken());
        MatchRequest req1 = new MatchRequest(face1.getFaceToken(), "FACE_TOKEN");
        MatchRequest req2 = new MatchRequest(face2.getFaceToken(), "FACE_TOKEN");
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        JSONObject res = this.client.match(requests);
        this.logger.info("matchTwoFace(FaceItem) result = {}", (Object)res);
        return 0.0;
    }

    @Override
    public double matchTwoImageFile(String file1, String file2) {
        MatchRequest req1 = new MatchRequest(FaceUtils.getImageBase64(file1), "BASE64");
        MatchRequest req2 = new MatchRequest(FaceUtils.getImageBase64(file2), "BASE64");
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        return this.doMatchProcess(requests);
    }

    @Override
    public double matchTwoImageBase64(String photo_live_base64, String imageBase64) {
        MatchRequest req1 = new MatchRequest(photo_live_base64, "BASE64", "LIVE", "NORMAL", "LOW");
        MatchRequest req2 = new MatchRequest(imageBase64, "BASE64", "CERT", null, null);
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        return this.doMatchProcess(requests);
    }

    @Override
    public double matchTwoImageBase64(String photo_live_base64, String imageBase64, String livenessControl) {
        MatchRequest req1 = new MatchRequest(photo_live_base64, "BASE64", "LIVE", "NORMAL", livenessControl);
        MatchRequest req2 = new MatchRequest(imageBase64, "BASE64", "CERT", null, null);
        ArrayList<MatchRequest> requests = new ArrayList<MatchRequest>();
        requests.add(req1);
        requests.add(req2);
        return this.doMatchProcess(requests);
    }

    private double doMatchProcess(List<MatchRequest> requests) {
        JSONObject res = this.client.match(requests);
        if (res == null) {
            throw new RuntimeException("\u8c03\u7528matchTwoImage\u63a5\u53e3\uff0c\u8fd4\u56de\u7a7a\u6570\u636e");
        }
        this.logger.info("face match result = {}", (Object)res);
        if (res.getInt("error_code") != 0) {
            this.logger.error("\u8c03\u7528detect\u63a5\u53e3\uff0c\u8fd4\u56de\u9519\u8bef\u6570\u636e\uff1a" + res.getString("error_msg"));
            throw new RuntimeException(res.getString("error_msg"));
        }
        JSONObject result = res.getJSONObject("result");
        return result.getDouble("score");
    }

    public void checkFaceClient() {
        if (this.client == null) {
            if (StringUtils.isEmpty((String)this.appId) || StringUtils.isEmpty((String)this.apiKey) || StringUtils.isEmpty((String)this.secretKey)) {
                throw new IllegalArgumentException("appId, apiKey, secretKey\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u767e\u5ea6OCR client!");
            }
            this.client = new AipFace(this.appId, this.apiKey, this.secretKey);
            this.client.setConnectionTimeoutInMillis(2000);
            this.client.setSocketTimeoutInMillis(60000);
            this.logger.info("\u767e\u5ea6: AipFace\u521d\u59cb\u5316\u6210\u529f");
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

