/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.table;

import com.walker.openocr.table.CellConfigItem;
import com.walker.openocr.table.ColumnConfigItem;
import com.walker.openocr.table.ConfigItem;
import com.walker.openocr.util.TableConfigUtils;
import java.util.ArrayList;
import java.util.List;

public class TableConfig {
    private List<String[]> tableTypeKeys = new ArrayList<String[]>(8);
    private int cellTolerance = 5;
    private float titleTolerance = 1.0f;
    private String[] removeColumnsName = null;
    private List<CellConfigItem> cellConfigItems = new ArrayList<CellConfigItem>(32);
    private List<ColumnConfigItem> columnConfigItems = new ArrayList<ColumnConfigItem>(8);
    private int multiLineTolerance = 30;
    private String tableTitle;
    private List<String> tableTitleNotKey = new ArrayList<String>(4);

    public String getTableTitle() {
        return this.tableTitle;
    }

    public void setTableTitle(String tableTitle) {
        this.tableTitle = tableTitle;
    }

    public int getMultiLineTolerance() {
        return this.multiLineTolerance;
    }

    public void setMultiLineTolerance(int multiLineTolerance) {
        this.multiLineTolerance = multiLineTolerance;
    }

    public int getCellTolerance() {
        return this.cellTolerance;
    }

    public void setCellTolerance(int cellTolerance) {
        this.cellTolerance = cellTolerance;
    }

    public float getTitleTolerance() {
        return this.titleTolerance;
    }

    public void setTitleTolerance(float titleTolerance) {
        this.titleTolerance = titleTolerance;
    }

    public String[] getRemoveColumnsName() {
        return this.removeColumnsName;
    }

    public void setRemoveColumnsName(String[] removeColumnsName) {
        this.removeColumnsName = removeColumnsName;
    }

    public List<String[]> getTableTypeKeys() {
        return this.tableTypeKeys;
    }

    public void setTableTypeKeys(String text) {
        if (text == null || text.equals("")) {
            throw new IllegalArgumentException("tableTypeKeys is required!");
        }
        String[] array = text.split("\\|");
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException("\u5206\u9694\u5b57\u7b26\u4e32\u9519\u8bef\uff1atableConfig\u53c2\u6570\u9519\u8bef\uff1a" + text);
        }
        String[] keys = null;
        for (String one : array) {
            keys = one.split(",");
            this.tableTypeKeys.add(keys);
        }
    }

    public void addCellConfig(CellConfigItem item) {
        if (item == null) {
            return;
        }
        if (this.cellConfigItems.contains(item)) {
            return;
        }
        this.cellConfigItems.add(item);
    }

    public void addColumnConfig(ColumnConfigItem item) {
        if (item == null) {
            return;
        }
        if (this.columnConfigItems.contains(item)) {
            return;
        }
        this.columnConfigItems.add(item);
    }

    public CellConfigItem getCellConfigItem(String id) {
        if (this.cellConfigItems.size() == 0) {
            return null;
        }
        for (CellConfigItem item : this.cellConfigItems) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public CellConfigItem getCellConfig(String name) {
        if (this.cellConfigItems.size() == 0) {
            return null;
        }
        for (CellConfigItem item : this.cellConfigItems) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public ColumnConfigItem getColumnConfig(String name) {
        if (this.columnConfigItems.size() == 0) {
            return null;
        }
        for (ColumnConfigItem item : this.columnConfigItems) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String[] keys : this.tableTypeKeys) {
            for (String s : keys) {
                sb.append(s).append(",");
            }
        }
        return sb.toString();
    }

    public ConfigItem findConfigItem(String text) {
        ArrayList<CellConfigItem> matchedList = new ArrayList<CellConfigItem>(2);
        for (CellConfigItem item : this.cellConfigItems) {
            if (!TableConfigUtils.isCellConfigItem(item, text, this)) continue;
            matchedList.add(item);
        }
        if (matchedList.size() == 1) {
            return (ConfigItem)matchedList.get(0);
        }
        if (matchedList.size() > 1) {
            float[] scores = new float[matchedList.size()];
            for (int i = 0; i < matchedList.size(); ++i) {
                scores[i] = TableConfigUtils.getSimpleSimilarScore(((CellConfigItem)matchedList.get(i)).getName(), text);
            }
            float maxScore = 0.0f;
            int maxIndex = 0;
            for (int j = 0; j < scores.length; ++j) {
                if (!(scores[j] > maxScore)) continue;
                maxScore = scores[j];
                maxIndex = j;
            }
            System.out.println("\u53d1\u73b0\u591a\u4e2a\u914d\u7f6e\u5339\u914d\uff0c\u627e\u5230\u6700\u9ad8\u8bc4\u5206:" + maxScore + ", config=" + ((CellConfigItem)matchedList.get(maxIndex)).getName());
            return (ConfigItem)matchedList.get(maxIndex);
        }
        return null;
    }

    public List<String> getTableTitleNotKey() {
        return this.tableTitleNotKey;
    }

    public void setTableTitleNotKey(List<String> tableTitleNotKey) {
        this.tableTitleNotKey = tableTitleNotKey;
    }
}

