/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.table;

import com.walker.openocr.AbstractTextResolver;
import com.walker.openocr.OcrType;
import com.walker.openocr.TextBlock;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableObject;
import com.walker.openocr.util.TableObjectUtils;
import java.util.ArrayList;
import java.util.List;

public class TableTextResolver
extends AbstractTextResolver<TableObject, TableConfig> {
    public TableTextResolver() {
        this.setOcrType(OcrType.TextTable);
    }

    @Override
    protected TableObject doResolveGeneric(List<TextBlock> dataList, List<TableConfig> configList) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    @Override
    protected TableObject doResolveIdCard(List<TextBlock> dataList, List<TableConfig> configList) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    @Override
    protected TableObject doResolveTable(List<TextBlock> dataList, List<TableConfig> configList) {
        if (configList == null || configList.size() == 0) {
            this.logger.error("table configList \u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u89e3\u6790\u8868\u683c\u5bf9\u8c61");
            return null;
        }
        TableConfig tableConfig = this.getTableType(dataList, configList);
        if (tableConfig == null) {
            this.logger.error("\u672a\u627e\u5230\uff1atableConfig\uff0c\u5c1d\u8bd5\u4f7f\u7528\u6700\u540e\u4e00\u4e2a\u4f5c\u4e3a\u515c\u5e95\u6a21\u677f\u914d\u7f6e");
            tableConfig = configList.get(configList.size() - 1);
        }
        TableObject tableObject = new TableObject(tableConfig);
        this.flowTableObject(tableObject, tableConfig, dataList);
        return tableObject;
    }

    protected void flowTableObject(TableObject tableObject, TableConfig tableConfig, List<TextBlock> dataList) {
        List<TextBlock> availableList = this.filterRemovedNames(tableConfig, dataList);
        if (availableList != null) {
            for (TextBlock tb : availableList) {
                tableObject.addTextBlock(tb);
            }
        }
        tableObject.sortCellObjectList();
        tableObject.calculateValue();
        tableObject.printRowCache();
    }

    private List<TextBlock> filterRemovedNames(TableConfig tableConfig, List<TextBlock> dataList) {
        String[] removeNames = tableConfig.getRemoveColumnsName();
        if (removeNames == null || removeNames.length == 0) {
            this.logger.info("tableConfig:\u672a\u914d\u7f6e\u79fb\u9664\u5173\u952e\u8bcd");
            return dataList;
        }
        ArrayList<TextBlock> availableList = new ArrayList<TextBlock>();
        for (TextBlock textBlock : dataList) {
            boolean exist = false;
            for (String name : removeNames) {
                if (!textBlock.getText().equals(name)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                availableList.add(textBlock);
                continue;
            }
            this.logger.debug("\u79fb\u9664\u6570\u636e: " + textBlock.getText());
        }
        return availableList;
    }

    private TableConfig getTableType(List<TextBlock> dataList, List<TableConfig> configList) {
        List<String[]> tableKeysList = null;
        for (TableConfig tableConfig : configList) {
            if (tableConfig.getTableTitleNotKey().size() > 0 && TableObjectUtils.containTableKeyNot(dataList, tableConfig.getTableTitleNotKey())) {
                this.logger.debug("\u7ee7\u7eed\u4e0b\u4e00\u4e2a\uff0c\u6807\u9898\u5305\u542b\u4e86\u6392\u9664\u5173\u952e\u8bcd\uff1a{}", tableConfig.getTableTitleNotKey());
                continue;
            }
            tableKeysList = tableConfig.getTableTypeKeys();
            if (tableKeysList == null || tableKeysList.size() == 0) {
                throw new IllegalArgumentException("TableConfig\u4e2d\u672a\u914d\u7f6e\uff1atableTypeKeys\u5c5e\u6027, table=" + tableConfig.getTableTypeKeys());
            }
            if (tableKeysList.size() > 1) {
                throw new UnsupportedOperationException("\u6682\u65f6\u6ca1\u5b9e\u73b0\u591a\u7ec4\u5173\u952e\u8bcd\u5e76\u5217\u4ee3\u7801\uff0c\u8bf7\u4f7f\u7528\u5355\u7ec4\uff0c\u5982\uff1a\u5927\u5730,\u4fdd\u9669,\u673a\u52a8\u8f66");
            }
            int successSize = 0;
            block1: for (String s : tableKeysList.get(0)) {
                for (TextBlock textBlock : dataList) {
                    if (!textBlock.getText().contains(s)) continue;
                    ++successSize;
                    continue block1;
                }
            }
            if (successSize <= 0 || successSize != tableKeysList.get(0).length) continue;
            this.logger.info("\u641c\u7d22\u5230\u8868\u683c\u7c7b\u578b\uff1a" + tableConfig);
            return tableConfig;
        }
        return null;
    }
}

