/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.util;

import com.walker.openocr.TextBlock;
import com.walker.openocr.table.CellObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableObjectUtils {
    private static final transient Logger logger = LoggerFactory.getLogger(TableObjectUtils.class);

    public static final boolean containTableKeyNot(List<TextBlock> dataList, List<String> tableKeysNot) {
        for (TextBlock textBlock : dataList) {
            for (String notKey : tableKeysNot) {
                if (textBlock.getText().indexOf(notKey) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static final String formatText(String text) {
        text = text.replaceAll("\uff08", "(");
        text = text.replaceAll("\uff09", ")");
        text = text.replaceAll("\uff1a", ":");
        return text.trim();
    }

    public static final boolean isInSameRow(CellObject source, CellObject target, int cellTolerance) {
        float targetY;
        float sourceY = source.getSource().getStartPosition()[1];
        if (Math.abs(sourceY - (targetY = target.getSource().getStartPosition()[1])) <= (float)cellTolerance) {
            return true;
        }
        sourceY = source.getSource().getEndPosition()[1];
        return Math.abs(sourceY - (targetY = target.getSource().getEndPosition()[1])) <= (float)cellTolerance;
    }

    public static final void sortColumnCellList(List<CellObject> list) {
        int columnSort = 1;
        CellObject min = TableObjectUtils.findMinColumnCellObject(list, null);
        min.setOrderColumn(columnSort);
        CellObject currentMin = min;
        for (CellObject cellObject : list) {
            ++columnSort;
            if ((currentMin = TableObjectUtils.findMinColumnCellObject(list, currentMin)) == null) continue;
            currentMin.setOrderColumn(columnSort);
        }
        Collections.sort(list);
    }

    private static CellObject findMinColumnCellObject(List<CellObject> list, CellObject minCell) {
        CellObject find = null;
        for (CellObject co : list) {
            if (minCell != null && co.getSource().getStartPosition()[0] <= minCell.getSource().getStartPosition()[0]) continue;
            if (find == null) {
                find = co;
                continue;
            }
            if (!(co.getSource().getStartPosition()[0] < find.getSource().getStartPosition()[0])) continue;
            find = co;
        }
        return find;
    }

    public static List<CellObject> findNextRowInfo(CellObject current, List<CellObject> others, int lineHeight, int cellTolerance) {
        if (others == null || others.size() == 0) {
            return null;
        }
        ArrayList<CellObject> resultList = new ArrayList<CellObject>(4);
        float currentY = current.getSource().getStartPosition()[1];
        float nextRowY = 0.0f;
        float distance = 0.0f;
        for (CellObject co : others) {
            nextRowY = co.getSource().getStartPosition()[1];
            distance = Math.abs(currentY - nextRowY);
            if (!(distance + (float)cellTolerance >= (float)lineHeight) || !(distance <= (float)(2 * lineHeight))) continue;
            logger.debug("distance=" + distance + ", lineHeight=" + lineHeight + ", text=" + co.getSource().getText());
            resultList.add(co);
        }
        return resultList;
    }

    public static final CellObject findNextRowCell(CellObject current, List<CellObject> others, int lineHeight, int cellTolerance) {
        List<CellObject> rowCellList = TableObjectUtils.findNextRowInfo(current, others, lineHeight, cellTolerance);
        if (rowCellList == null || rowCellList.size() == 0) {
            return null;
        }
        if (current.isConfigurable()) {
            float currentX = current.getSource().getEndPosition()[0];
            float currentY = current.getSource().getEndPosition()[1];
            float targetX = 0.0f;
            Object topCell = null;
            for (CellObject co : rowCellList) {
                targetX = co.getSource().getStartPosition()[0];
                if (targetX < currentX || !(co.getSource().getStartPosition()[1] <= currentY)) continue;
                logger.debug("\u6807\u9898\u683c \u53f3\u4fa7 \u627e\u5230\u591a\u884c\u503c\u5355\u5143\u683c\u9760\u4e0a\u4e00\u4e2a:" + co.getSource().getText());
                return co;
            }
        } else {
            float currentX = current.getSource().getStartPosition()[0];
            float targetX = 0.0f;
            for (CellObject co : rowCellList) {
                targetX = co.getSource().getStartPosition()[0];
                if (!(Math.abs(currentX - targetX) <= (float)cellTolerance)) continue;
                logger.debug("\u627e\u5230\u5339\u914d\u7684\u4e0b\u4e00\u884c\u5355\u5143\u683c:" + co.getSource().getText());
                return co;
            }
        }
        return null;
    }

    public static final String parseSplitTitleAndValue(CellObject cellObject, boolean splitTitleValue) {
        String text = cellObject.getSource().getText();
        if (splitTitleValue && text.indexOf(":") > 0) {
            String[] titleValue = text.split(":");
            if (titleValue.length != 2) {
                logger.error("\u5185\u5bb9\u901a\u8fc7:\u5206\u9694\u4e3a\u7a7a=" + text);
                return "";
            }
            return titleValue[1];
        }
        if (cellObject.isConfigurable()) {
            int titleIndexStart = text.indexOf(cellObject.getCellConfigItem().getName());
            String perhapsValue = text.replaceFirst(cellObject.getCellConfigItem().getName(), "");
            if (titleIndexStart > 0 && perhapsValue.length() == titleIndexStart) {
                logger.debug("\u672a\u68c0\u7d22\u5230\u503c\uff1a\u5339\u914d\u7684\u6807\u9898\u5728\u540e\u9762\uff0c\u8bf4\u660e\u503c\u53ef\u80fd\u4e0d\u6b63\u786e:" + text);
                return "";
            }
            if (perhapsValue.length() >= cellObject.getMinValueSize()) {
                logger.debug("\u5728\u6807\u9898\u683c\u627e\u5230\u53ef\u80fd\u7684\u503c:" + perhapsValue + ", title=" + cellObject.getCellConfigItem().getName());
                return perhapsValue;
            }
            return "";
        }
        return text;
    }

    public static final String parseFullRowTwoLineValue(List<CellObject> rowData, CellObject current, List<CellObject> nextLineCells) {
        String result = TableObjectUtils.parseSplitTitleAndValue(current, false);
        StringBuilder sb = new StringBuilder(result);
        if (rowData != null) {
            sb.append(";");
            for (CellObject co : rowData) {
                if (co.isConfigurable() || co.getOrderColumn() <= 0) continue;
                sb.append(co.getSource().getText()).append(";");
            }
        }
        if (nextLineCells != null) {
            for (CellObject co : nextLineCells) {
                if (co.isConfigurable()) continue;
                sb.append(co.getSource().getText()).append(";");
            }
        }
        return sb.toString();
    }

    public static final String parseCellTwoLineValue(CellObject currentValue, CellObject nextLineValue, boolean splitTitleValue) {
        if (nextLineValue == null) {
            return TableObjectUtils.parseSplitTitleAndValue(currentValue, splitTitleValue);
        }
        StringBuilder sb = new StringBuilder();
        if (currentValue.getSource().getStartPosition()[1] < nextLineValue.getSource().getStartPosition()[1]) {
            sb.append(TableObjectUtils.parseSplitTitleAndValue(currentValue, splitTitleValue));
            sb.append(nextLineValue.getSource().getText());
        } else {
            sb.append(nextLineValue.getSource().getText());
            sb.append(TableObjectUtils.parseSplitTitleAndValue(currentValue, splitTitleValue));
        }
        return sb.toString();
    }
}

