/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.vehicle;

import com.walker.openocr.AbstractValueParser;
import com.walker.openocr.util.TableConfigUtils;
import com.walker.openocr.util.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class CarTypeValueParser
extends AbstractValueParser<String> {
    private List<String> standardTypeSet = new ArrayList<String>(12);

    public CarTypeValueParser() {
        this.standardTypeSet.add("\u5fae\u578b\u8f7f\u8f66");
        this.standardTypeSet.add("\u5c0f\u578b\u8f7f\u8f66");
        this.standardTypeSet.add("\u4e2d\u578b\u8f7f\u8f66");
        this.standardTypeSet.add("\u5927\u578b\u8f7f\u8f66");
        this.standardTypeSet.add("\u5c0f\u578b\u666e\u901a\u5ba2\u8f66");
        this.standardTypeSet.add("\u5c0f\u578b\u8d8a\u91ce\u5ba2\u8f66");
        this.standardTypeSet.add("\u5c0f\u578b\u4e13\u7528\u5ba2\u8f66");
        this.standardTypeSet.add("\u5fae\u578b\u666e\u901a\u5ba2\u8f66");
        this.standardTypeSet.add("\u5fae\u578b\u8d8a\u91ce\u5ba2\u8f66");
    }

    @Override
    public String getValue(Object input) {
        if (TextUtils.isEmpty(input)) {
            return null;
        }
        String text = input.toString();
        double maxScore = 0.0;
        double currentScore = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < this.standardTypeSet.size(); ++i) {
            currentScore = TableConfigUtils.getSimpleSimilarScore(this.standardTypeSet.get(i), text);
            if (!(currentScore > maxScore)) continue;
            maxScore = currentScore;
            maxIndex = i;
        }
        if (maxScore >= 0.7) {
            this.logger.debug("maxScore = " + maxScore + ", index = " + maxIndex);
            return this.standardTypeSet.get(maxIndex);
        }
        return null;
    }

    @Override
    public boolean isTypeValue(Object input) {
        return this.getValue(input) != null;
    }
}

