/*
 * Decompiled with CFR 0.152.
 */
package com.walker.openocr.vehicle;

import com.walker.openocr.ValueParser;
import com.walker.openocr.table.CellObject;
import com.walker.openocr.table.TableConfig;
import com.walker.openocr.table.TableObject;
import com.walker.openocr.util.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VehicleLicenseTable
extends TableObject {
    private Map<String, ValueParser> idParserMap = new HashMap<String, ValueParser>(8);
    private Map<String, CellObject> tableData = new HashMap<String, CellObject>();

    public VehicleLicenseTable(TableConfig tableConfig, List<ValueParser> valueParserList) {
        super(tableConfig);
        if (valueParserList == null || valueParserList.size() == 0) {
            this.logger.warn("valueParserList \u6ca1\u6709\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u66f4\u597d\u89e3\u6790\u884c\u9a76\u8bc1\u5c5e\u6027\u53c2\u6570");
        } else {
            for (ValueParser valueParser : valueParserList) {
                this.idParserMap.put(valueParser.getName(), valueParser);
            }
        }
    }

    @Override
    public void printRowCache() {
        super.printRowCache();
        this.logger.debug("~~~~~~~~~~~~~~~~~ table data ~~~~~~~~~~~~~~~~~");
        for (CellObject other : this.tableData.values()) {
            this.logger.debug(other.toString());
        }
    }

    @Override
    public Map<String, CellObject> getTableDataMap() {
        return this.tableData;
    }

    @Override
    public void calculateValue() {
        super.calculateValue();
        if (this.rowCache.size() > 0) {
            for (List list : this.rowCache.values()) {
                for (CellObject co : list) {
                    if (!co.isConfigurable()) continue;
                    this.tableData.put(co.getId(), co);
                }
            }
        }
        this.predictValue("hao_pai_hao_ma");
        this.predictValue("che_liang_lei_xing");
        this.predictValue("zhu_zhi");
        this.predictValue("che_liang_shi_bie_dai_ma");
    }

    private void predictValue(String id) {
        String predictValue;
        ValueParser valueParser = this.idParserMap.get(id);
        CellObject one = this.tableData.get(id);
        if (one != null && !TextUtils.isEmpty(one.getValue())) {
            if (valueParser != null && valueParser.isTypeValue(one.getValue())) {
                return;
            }
        } else if (one != null && one.getValue() == null) {
            if (valueParser != null && valueParser.isTypeValue(one.getValue())) {
                return;
            }
        } else if (one == null) {
            one = new CellObject();
            one.setId(id);
            this.tableData.put(id, one);
        }
        if ((predictValue = this.parseValue(id, valueParser)) != null) {
            if (!one.isConfigurable()) {
                this.logger.debug(predictValue + " \u6ca1\u6709\u914d\u7f6e\u9879\uff0c\u521b\u5efa\u4e00\u4e2a: " + id);
                one.setCellConfigItem(this.getRecognizeConfig().getCellConfigItem(id));
            }
            one.setValue(predictValue);
            one.setId(id);
        }
    }

    private String parseValue(String id, ValueParser valueParser) {
        if (valueParser == null) {
            return null;
        }
        Object result = null;
        for (List list : this.rowCache.values()) {
            for (CellObject co : list) {
                result = valueParser.getValue(co.getSource().getText());
                if (result == null) continue;
                this.logger.debug("\u627e\u5230\u6210\u529f\u89e3\u6790\u7684\u5c5e\u6027\u503c:" + co.getId() + ", " + co.getSource().getText());
                return result.toString();
            }
        }
        if (result == null) {
            for (CellObject co : this.otherCellObjectList) {
                result = valueParser.getValue(co.getSource().getText());
                if (result == null) continue;
                this.logger.debug("\u627e\u5230'otherCellObjectList'\u89e3\u6790\u7684\u5c5e\u6027\u503c:" + co.getId() + ", " + co.getSource().getText());
                return result.toString();
            }
        }
        return null;
    }
}

