package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.exception.OrderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public abstract class AbstractOrderGenerator implements OrderGenerator {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ResponsePay generate(String providerPayType, Order platformOrder, Map<String, Variable> configuration) throws OrderException {
        try {
            return this.invoke(providerPayType, platformOrder, configuration);
        } catch (Exception ex){
            throw new OrderException(String.valueOf(platformOrder.getId()), ex.getMessage(), ex);
        }
    }

    @Override
    public ResponsePay generate(PayContext payContext, Order platformOrder) throws OrderException {
        try {
            return this.invoke(payContext, platformOrder);
        } catch (Exception ex){
            throw new OrderException(String.valueOf(platformOrder.getId()), ex.getMessage(), ex);
        }
    }

    /**
     * 调用第三方获取订单信息。
     * @param payContext
     * @param platformOrder
     * @return
     * @date 2023-02-17
     */
    protected abstract ResponsePay invoke(PayContext payContext, Order platformOrder);

    /**
     * 提交请求第三方获取预订单。<p></p>
     * 该方法废弃，请使用 {@linkplain AbstractOrderGenerator#invoke(PayContext, Order)}
     * @param providerPayType 第三方定义的支付方式，如: 微信v2中的 NATIVE/APP等
     * @param platformOrder 平台定义的订单
     * @param configuration
     * @return
     */
    @Deprecated
    protected abstract ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration);
}
