package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPayContext implements PayContext{

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public String getProviderPayType(){
        return this.providerPayType;
    }

    @Override
    public PayDefinition getPayDefinition() {
        return this.payDefinition;
    }

    @Override
    public Variable getConfigVariable(String key) {
        if(!configuration.containsKey(key)){
            logger.error("支付参数未找到:{}", key);
            return null;
        }
        return this.configuration.get(key);
    }

    @Override
    public void setConfigVariable(Variable variable) {
        if(configuration.containsKey(variable.getId())){
            logger.warn("配置参数已存在，重复设置会覆盖之前数据，id={}, 新设置值={}", variable.getId(), variable.toString());
        }
        this.configuration.put(variable.getId(), variable);
    }

    /**
     * 设置支付定义对象。
     * @param payDefinition
     */
    public void setPayDefinition(PayDefinition payDefinition) {
        this.payDefinition = payDefinition;
    }

    /**
     * 设置第三方支付定义的支付类型字符串
     * @param providerPayType
     */
    public void setProviderPayType(String providerPayType) {
        this.providerPayType = providerPayType;
    }

    private String providerPayType = null;
    private Map<String, Variable> configuration = new HashMap<>(8);

    private PayDefinition payDefinition;
}
