package com.walker.pay;

/**
 * 通知结果数据格式定义。<p></p>
 * 该结果外层是一些通用属性，里面业务数据由子类确定。
 */
public class NotifyValue<T> {

    /**
     * 返回通知ID
     * @return
     */
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    /**
     * 返回通知创建时间，该属性是从第三方支付获取的，转换成统一格式，如：202301170946
     * @return
     */
    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    /**
     * 是否支付成功，如果通知支付成功，则返回 true, 否则 false。<p></p>
     * 该值并不表示接收通知成功，表示通知中已经支付成功。
     * @return
     * @date 2023-02-28
     */
    public boolean isStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    /**
     * 返回通知的数据类型
     * @return
     */
    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    /**
     * 返回系统订单号
     * @return
     */
    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 返回第三方(如:微信)订单号
     * @return
     */
    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * 返回支付服务商信息
     * @return
     */
    public ServiceProvider getServiceProvider() {
        return serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    /**
     * 返回渠道信息
     * @return
     */
    public PayChannel getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(PayChannel payChannel) {
        this.payChannel = payChannel;
    }

    /**
     * 返回支付提供商实现的版本号
     * @return
     */
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * 返回通知的原始数据。
     * @return
     */
    public Object getSource() {
        return source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    /**
     * 返回第三方的购买人标识，如:微信 openid 或支付宝 user_id等。
     * @return
     * @date 2023-02-17
     */
    public String getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    /**
     * 第三方支付通知返回的交易类型，例如：微信 trade_type 字段区别支付方式等。
     * @return
     * @date 2023-08-30
     */
    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    private String tradeType;
    private String buyerId;

    // 接收通知的原始数据
    private Object source = null;

    private ServiceProvider serviceProvider;
    private PayChannel payChannel;
    private String version;

    private String orderId;
    private String tradeNo;

    private String id;
    private String createTime;

    private boolean status = false;
    private String dataType;

    private T data;

}
