package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.exception.OrderException;

import java.util.Map;

/**
 * 预下单生成器接口定义，每个提供商都存在多个生成器，如: 扫描订单、H5订单等。
 * @author 时克英
 * @@date 2023-01-15
 */
public interface OrderGenerator {

    /**
     * 生成订单，远程调用第三方支付生成订单实现。<p></p>
     * 该方法废弃，请使用 {@linkplain OrderGenerator#generate(PayContext, Order)}
     * @param providerPayType 第三方定义的支付方式，如: 微信v2中的 NATIVE/APP等
     * @param platformOrder
     * @param configuration
     * @return orderValue 返回订单响应数据，是第三方支付返回的具体业务数据。
     * @throws OrderException 订单调用异常
     */
    @Deprecated
    ResponsePay generate(String providerPayType, Order platformOrder, Map<String, Variable> configuration) throws OrderException;

    /**
     * 生成预下单记录，该方法底层远程调用第三方支付系统。
     * @param payContext 支付上下文
     * @param platformOrder 业务提交订单
     * @return
     * @throws OrderException
     * @date 2023-02-17
     */
    ResponsePay generate(PayContext payContext, Order platformOrder) throws OrderException;
}
