package com.walker.pay;

/**
 * 订单状态查询，请求对象。
 * @author 时克英
 * @date 2023-02-23
 */
public class OrderStatusQuery {

    /**
     * 系统内部订单号
     * @return
     */
    public long getOrderId() {
        return orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    /**
     * 第三方支付系统订单号
     * @return
     */
    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * 对接的第三方支付系统中，设置的平台商户号(微信使用)
     * @return
     */
    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    /**
     * 第三方系统提供给我们的应用标识，如：微信appid登。
     * @return
     * @date 2023-08-30
     */
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 签名密钥。
     * @return
     * @date 2023-08-30
     */
    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private String apiKey;
    private String appId;
    private long orderId;
    private String tradeNo;
    private String merchantId;
}
