package com.walker.pay;

/**
 * 支付渠道。
 * @author 时克英
 * @date 2023-01-12
 */
public enum PayChannel {

    ProviderDirect {
        public int getIndex(){
            return INDEX_PROVIDER_DIRECT;
        }
        public String getName(){
            return NAME_PROVIDER_DIRECT;
        }
    },
    ProviderProxy {
        public int getIndex(){
            return INDEX_PROVIDER_PROXY;
        }
        public String getName(){
            return NAME_PROVIDER_PROXY;
        }
    },
    Pos {
        public int getIndex(){
            return INDEX_POS;
        }
        public String getName(){
            return NAME_POS;
        }
    },
    InternetBank {
        public int getIndex(){
            return INDEX_INTERNET_BANK;
        }
        public String getName(){
            return NAME_INTERNET_BANK;
        }
    },
    WechatPay {
        public int getIndex(){
            return INDEX_WECHAT_PAY;
        }
        public String getName(){
            return NAME_WECHAT_PAY;
        }
    },
    Alipay {
        public int getIndex(){
            return INDEX_ALI_PAY;
        }
        public String getName(){
            return NAME_ALI_PAY;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }
    public String getName(){
        throw new AbstractMethodError();
    }

    public static final PayChannel getType(int index){
        if(index == INDEX_PROVIDER_DIRECT){
            return ProviderDirect;
        } else if(index == INDEX_PROVIDER_PROXY){
            return ProviderProxy;
        } else if(index == INDEX_POS){
            return Pos;
        } else if(index == INDEX_INTERNET_BANK){
            return InternetBank;
        } else if(index == INDEX_WECHAT_PAY){
            return WechatPay;
        } else if(index == INDEX_ALI_PAY){
            return Alipay;
        } else {
            throw new UnsupportedOperationException("不支持的渠道:" + index);
        }
    }

    public static final int INDEX_PROVIDER_DIRECT = 0;
    public static final int INDEX_PROVIDER_PROXY = 1;
    public static final int INDEX_POS = 2;
    public static final int INDEX_INTERNET_BANK = 3;
    public static final int INDEX_WECHAT_PAY = 5;
    public static final int INDEX_ALI_PAY = 6;

    /**
     * 由于存在第三方(如:通联)也能间接调用微信、支付宝等，因此渠道字段中，服务商直连主要是针对的:通联、易宝等第三方支付机构。
     */
    public static final String NAME_PROVIDER_DIRECT = "服务商直连";
    public static final String NAME_PROVIDER_PROXY = "代理服务商";
    public static final String NAME_POS = "POS";
    public static final String NAME_INTERNET_BANK = "网银";
    public static final String NAME_WECHAT_PAY = "微信支付直连";
    public static final String NAME_ALI_PAY = "支付宝直连";
}
