package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;

/**
 * 支付上下文对象定义，在支付环节中使用，它包含:支付操作的整个环境管理。
 * @author 时克英
 * @date 2023-02-17
 */
public interface PayContext {

    /**
     * 返回第三方支付定义的 '支付类型' 字符串
     * @return
     * @date 2023-02-17
     */
    String getProviderPayType();

    /**
     * 返回 当前使用的支付定义对象。
     * @return
     * @date 2023-02-17
     */
    PayDefinition getPayDefinition();

    /**
     * 返回配置的参数值对象。
     * @param key 用户定义的参数ID
     * @return
     * @date 2023-02-17
     */
    Variable getConfigVariable(String key);

    /**
     * 设置配置的参数值对象。
     * @param variable
     * @date 2023-02-17
     */
    void setConfigVariable(Variable variable);
}
