package com.walker.pay;

import com.walker.infrastructure.ApplicationException;

/**
 * 支付系统异常定义，业务需要捕获。
 * @author 时克英
 * @date 2023-01-16
 */
public class PayException extends ApplicationException {

    public PayException(String orderId, Throwable caution){
        super("支付异常，orderId = " + orderId, caution);
        this.orderId = orderId;
    }
    public PayException(String orderId, String msg, Throwable caution){
        super("支付异常，orderId = " + orderId + "," + msg, caution);
        this.orderId = orderId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    private String orderId = null;
}
