package com.walker.pay;

/**
 * 付款来源。
 * @author 时克英
 * @date 2023-01-12
 */
public enum PayFrom {

    Bank {
        public int getIndex(){
            return INDEX_BANK;
        }
        public String getName(){
            return NAME_BANK;
        }
    },
    AccountBalance {
        public int getIndex(){
            return INDEX_ACCOUNT_BALANCE;
        }
        public String getName(){
            return NAME_ACCOUNT_BALANCE;
        }
    },
    Credit {
        public int getIndex(){
            return INDEX_CREDIT;
        }
        public String getName(){
            return NAME_CREDIT;
        }
    },
    TokenMoney {
        public int getIndex(){
            return INDEX_TOKEN_MONEY;
        }
        public String getName(){
            return NAME_TOKEN_MONEY;
        }
    },
    Other {
        public int getIndex(){
            return INDEX_OTHER;
        }
        public String getName(){
            return NAME_OTHER;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }
    public String getName(){
        throw new AbstractMethodError();
    }

    public static final PayFrom getType(int index){
        if(index == INDEX_BANK){
            return Bank;
        } else if(index == INDEX_ACCOUNT_BALANCE){
            return AccountBalance;
        } else if(index == INDEX_CREDIT){
            return Credit;
        } else if(index == INDEX_TOKEN_MONEY){
            return TokenMoney;
        } else if(index == INDEX_OTHER){
            return Other;
        } else {
            throw new UnsupportedOperationException("不支持的付款来源:" + index);
        }
    }

    public static final int INDEX_BANK = 0;
    public static final int INDEX_ACCOUNT_BALANCE = 1;
    public static final int INDEX_CREDIT = 2;
    public static final int INDEX_TOKEN_MONEY = 3;
    public static final int INDEX_OTHER = 9;

    public static final String NAME_BANK = "银行卡";
    public static final String NAME_ACCOUNT_BALANCE = "账户余额";
    public static final String NAME_CREDIT = "积分";
    public static final String NAME_TOKEN_MONEY = "代币";
    public static final String NAME_OTHER = "其他";
}
