package com.walker.pay;

/**
 * 支付状态定义。
 * @author 时克英
 * @date 2023-02-23
 */
public enum PayStatus {

    /**
     * 支付成功
     */
    Success {
        public String getIndex(){
            return INDEX_SUCCESS;
        }
    },

    /**
     * 交易成功，发生退款
     */
    Refund {
        public String getIndex(){
            return INDEX_REFUND;
        }
    },

    /**
     * 未支付
     */
    NotPay {
        public String getIndex(){
            return INDEX_NOT_PAY;
        }
    },

    /**
     * 交易关闭
     */
    Closed {
        public String getIndex(){
            return INDEX_CLOSED;
        }
    },

    /**
     * 交易失败
     */
    Error {
        public String getIndex(){
            return INDEX_ERROR;
        }
    },

    /**
     * 正在支付中
     */
    Paying {
        public String getIndex(){
            return INDEX_PAYING;
        }
    },

    /**
     * 订单初始化（已创建，未开始支付）
     * @date 2023-02-28
     */
    Created {
        public String getIndex(){
            return INDEX_CREATED;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }

    public static PayStatus getType(String index){
        if(index.equalsIgnoreCase(INDEX_SUCCESS)){
            return Success;
        } else if(index.equalsIgnoreCase(INDEX_REFUND)){
            return Refund;
        } else if(index.equalsIgnoreCase(INDEX_NOT_PAY)){
            return NotPay;
        } else if(index.equalsIgnoreCase(INDEX_ERROR)){
            return Error;
        } else if(index.equalsIgnoreCase(INDEX_CLOSED)){
            return Closed;
        } else if(index.equalsIgnoreCase(INDEX_PAYING)){
            return Paying;
        } else if(index.equalsIgnoreCase(INDEX_CREATED)){
            return Created;
        } else {
            throw new UnsupportedOperationException("不支持的支付状态:" + index);
        }
    }

    public static final String INDEX_SUCCESS = "success";
    public static final String INDEX_REFUND = "refund";
    public static final String INDEX_NOT_PAY = "not_pay";
    public static final String INDEX_CLOSED = "closed";
    public static final String INDEX_ERROR = "error";
    public static final String INDEX_PAYING = "paying";
    public static final String INDEX_CREATED = "created";
}
