package com.walker.pay;

/**
 * 支付类型。
 * @author 时克英
 * @date 2023-01-12
 */
public enum PayType {

    /**
     * 刷卡支付(或被扫)
     */
    Tap {
        public int getIndex(){
            return INDEX_TAP;
        }
        public String getName(){
            return NAME_TAP;
        }
    },

    /**
     * 公众号支付
     */
    OfficialAccount {
        public int getIndex(){
            return INDEX_OFFICIAL_ACCOUNT;
        }
        public String getName(){
            return NAME_OFFICIAL_ACCOUNT;
        }
    },

    /**
     * 扫码支付(生成商品支付二维码)
     */
    Scan {
        public int getIndex(){
            return INDEX_SCAN;
        }
        public String getName(){
            return NAME_SCAN;
        }
    },

    /**
     * APP支付
     */
    App {
        public int getIndex(){
            return INDEX_APP;
        }
        public String getName(){
            return NAME_APP;
        }
    },

    /**
     * 小程序支付
     */
    Applet {
        public int getIndex(){
            return INDEX_APPLET;
        }
        public String getName(){
            return NAME_APPLET;
        }
    },

    /**
     * H5支付
     */
    H5 {
        public int getIndex(){
            return INDEX_H5;
        }
        public String getName(){
            return NAME_H5;
        }
    },

    /**
     * 应用内支付
     */
    InApp {
        public int getIndex(){
            return INDEX_IN_APP;
        }
        public String getName(){
            return NAME_IN_APP;
        }
    },

    /**
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     * ~ 以下为 通商云 独立定义的支付方式。2023-02-17
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *
     * 通商云: 收银宝快捷支付（卡号、金额）
     * @date 2023-02-17
     */
    AllinPayCloud_QUICKPAY_VSP {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_QUICKPAY_VSP;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_QUICKPAY_VSP;
        }
    },

    /**
     * 通商云: 微信js公众号（收银宝）--> 微信公众号支付 appid（否）、微信js支付 openid
     * @date 2023-02-17
     */
    AllinPayCloud_WECHAT_PUBLIC {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_WECHAT_PUBLIC;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_WECHAT_PUBLIC;
        }
    },

    /**
     * 通商云: 支付宝js支付（生活号）--> 支付宝js支付 user_id
     * @date 2023-02-17
     */
    AllinPayCloud_ALIPAY_SERVIC {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_ALIPAY_SERVIC;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_ALIPAY_SERVIC;
        }
    },

    /**
     * 通商云: 微信小程序支付（收银宝）--> 微信js支付 openid
     * @date 2023-02-17
     */
    AllinPayCloud_WECHATPAY_MINIPROGRAM {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_WECHATPAY_MINIPROGRAM;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_WECHATPAY_MINIPROGRAM;
        }
    },

    /**
     * 通商云: 微信扫码支付(正扫，收银宝) -->
     * @date 2023-02-17
     */
    AllinPayCloud_SCAN_WEIXIN {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_SCAN_WEIXIN;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_SCAN_WEIXIN;
        }
    },

    /**
     * 通商云: 支付宝扫码支付(正扫，收银宝) -->
     * @date 2023-02-17
     */
    AllinPayCloud_SCAN_ALIPAY {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_SCAN_ALIPAY;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_SCAN_ALIPAY;
        }
    },

    /**
     * 通商云: 优惠券支付，用于运营账号补贴方式 -->
     * @date 2023-03-01
     */
    AllinPayCloud_COUPON {
        public int getIndex(){
            return INDEX_ALLINPAYCLOUD_COUPON;
        }
        public String getName(){
            return NAME_ALLINPAYCLOUD_COUPON;
        }
    },

    /**
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     * ~ 以下为 畅联（第三方）支付 独立定义的支付方式。2023-10-25
     * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     */

    /**
     * 畅联支付类型：支付宝单笔转账
     * @date 2023-10-25
     */
    PayUnk_TRANS_ALIPAY_ONE {
        public int getIndex(){
            return INDEX_PAYUNK_TRANS_ALIPAY_ONE;
        }
        public String getName(){
            return NAME_PAYUNK_TRANS_ALIPAY_ONE;
        }
    },

    /**
     * 畅联支付类型：支付宝代付单笔到用户
     * @date 2023-10-27
     */
    PayUnk_BEHALF_ALIPAY_ONE {
        public int getIndex(){
            return INDEX_PAYUNK_BEHALF_ALIPAY_ONE;
        }
        public String getName(){
            return NAME_PAYUNK_BEHALF_ALIPAY_ONE;
        }
    }
    ;

    public int getIndex(){
        throw new AbstractMethodError();
    }
    public String getName(){
        throw new AbstractMethodError();
    }

    public static PayType getType(int index){
        if(index == INDEX_TAP){
            return Tap;
        } else if(index == INDEX_OFFICIAL_ACCOUNT){
            return OfficialAccount;
        } else if(index == INDEX_SCAN){
            return Scan;
        } else if(index == INDEX_APP){
            return App;
        } else if(index == INDEX_APPLET){
            return Applet;
        } else if(index == INDEX_H5){
            return H5;
        } else if(index == INDEX_IN_APP){
            return InApp;
        } else if(index == INDEX_ALLINPAYCLOUD_QUICKPAY_VSP){
            return AllinPayCloud_QUICKPAY_VSP;
        } else if(index == INDEX_ALLINPAYCLOUD_WECHAT_PUBLIC){
            return AllinPayCloud_WECHAT_PUBLIC;
        } else if(index == INDEX_ALLINPAYCLOUD_ALIPAY_SERVIC){
            return AllinPayCloud_ALIPAY_SERVIC;
        } else if(index == INDEX_ALLINPAYCLOUD_WECHATPAY_MINIPROGRAM){
            return AllinPayCloud_WECHATPAY_MINIPROGRAM;
        } else if(index == INDEX_ALLINPAYCLOUD_SCAN_WEIXIN){
            return AllinPayCloud_SCAN_WEIXIN;
        } else if(index == INDEX_ALLINPAYCLOUD_SCAN_ALIPAY){
            return AllinPayCloud_SCAN_ALIPAY;
        } else if(index == INDEX_ALLINPAYCLOUD_COUPON){
            return AllinPayCloud_COUPON;
        } else if(index == INDEX_PAYUNK_TRANS_ALIPAY_ONE){
            return PayUnk_TRANS_ALIPAY_ONE;
        } else if(index == INDEX_PAYUNK_BEHALF_ALIPAY_ONE){
            return PayUnk_BEHALF_ALIPAY_ONE;
        } else {
            throw new UnsupportedOperationException("不支持的支付类型:" + index);
        }
    }

    public static final int INDEX_TAP = 0;
    public static final int INDEX_OFFICIAL_ACCOUNT = 1;
    public static final int INDEX_SCAN = 2;
    public static final int INDEX_APP = 3;
    public static final int INDEX_APPLET = 4;
    public static final int INDEX_H5 = 5;
    public static final int INDEX_IN_APP = 6;

    public static final int INDEX_ALLINPAYCLOUD_QUICKPAY_VSP = 11;
    public static final int INDEX_ALLINPAYCLOUD_WECHAT_PUBLIC = 12;
    public static final int INDEX_ALLINPAYCLOUD_ALIPAY_SERVIC = 13;
    public static final int INDEX_ALLINPAYCLOUD_WECHATPAY_MINIPROGRAM = 14;
    public static final int INDEX_ALLINPAYCLOUD_SCAN_WEIXIN = 15;
    public static final int INDEX_ALLINPAYCLOUD_SCAN_ALIPAY = 16;
    public static final int INDEX_ALLINPAYCLOUD_COUPON = 17;

    /**
     * 畅联支付方式：转账到支付宝（单笔）
     * @date 2023-10-25
     */
    public static final int INDEX_PAYUNK_TRANS_ALIPAY_ONE = 30;
    /**
     * 畅联支付方式：代付到支付宝（单笔）
     * @date 2023-10-27
     */
    public static final int INDEX_PAYUNK_BEHALF_ALIPAY_ONE = 31;

    public static final String NAME_TAP = "刷卡支付(被扫)";
    public static final String NAME_OFFICIAL_ACCOUNT = "公众号";
    public static final String NAME_SCAN = "扫码";
    public static final String NAME_APP = "APP";
    public static final String NAME_APPLET = "小程序";
    public static final String NAME_H5 = "H5";
    public static final String NAME_IN_APP = "应用内";

    public static final String NAME_ALLINPAYCLOUD_QUICKPAY_VSP = "收银宝快捷支付";
    public static final String NAME_ALLINPAYCLOUD_WECHAT_PUBLIC = "微信js公众号（收银宝）";
    public static final String NAME_ALLINPAYCLOUD_ALIPAY_SERVIC = "支付宝js支付（生活号）";
    public static final String NAME_ALLINPAYCLOUD_WECHATPAY_MINIPROGRAM = "微信小程序支付（收银宝）";
    public static final String NAME_ALLINPAYCLOUD_SCAN_WEIXIN = "微信扫码支付(正扫，收银宝)";
    public static final String NAME_ALLINPAYCLOUD_SCAN_ALIPAY = "支付宝扫码支付(正扫，收银宝)";
    public static final String NAME_ALLINPAYCLOUD_COUPON = "通商云优惠券支付";

    public static final String NAME_PAYUNK_TRANS_ALIPAY_ONE = "畅联单笔支付宝转账";
    public static final String NAME_PAYUNK_BEHALF_ALIPAY_ONE = "畅联单笔支付宝代付";
}
