package com.walker.pay;

import com.walker.infrastructure.utils.ClassUtils;
import com.walker.infrastructure.utils.StringUtils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 定义基础通知对象，可提供一些基础方法，目前只有生成序列化签名。<p></p>
 * 该对象通常是第三方通知请求的原始数据，子类根据业务属性继承使用，并定义属性。
 * @author 时克英
 * @date 2023-03-06
 */
public abstract class RequestNotifyBean {

    /**
     * 转换成签名序列化字符串，按照key/value拼接方式，以字母表顺序。
     * @return
     * @date 2023-03-06
     */
    public String toSignSerialize(){
        Field[] fields = this.getClass().getDeclaredFields();
        List<String> fieldNameList = new ArrayList<>(8);
        for(int i=0;i<fields.length;i++){
            fieldNameList.add(fields[i].getName());
        }
        Collections.sort(fieldNameList);
        System.out.println(fieldNameList);
        if(StringUtils.isEmptyList(fieldNameList)){
            return StringUtils.EMPTY_STRING;
        }

        StringBuilder sb = new StringBuilder();
        for(int i=0; i<fieldNameList.size(); i++){
            if(i > 0){
                sb.append(StringUtils.CHAR_AND);
            }
            sb.append(fieldNameList.get(i))
                    .append(StringUtils.CHAR_EQUALS)
                    .append(ClassUtils.getFieldValueByName(fieldNameList.get(i), this));
        }
        return sb.toString();
    }
}
