package com.walker.pay;

import com.walker.infrastructure.utils.StringUtils;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

/**
 * 订单请求返回响应对象。<p></p>
 * 第三方如:微信、通联等返回的实际结果。
 * @author 时克英
 * @date 2023-01-15
 */
public class ResponsePay {

//    protected static final Logger logger = LoggerFactory.getLogger(ResponsePay.class);
//    private static final Map<String, Class<?>> responsePayClassCache = new HashMap<>(64);

    /**
     * 创建并返回一个错误响应。
     * @param clazz 业务提供响应类型，如: ResponseBindPhone
     * @param errorMsg 错误信息
     * @return
     * @param <T>
     * @date 2023-02-24
     */
    public static final <T extends ResponsePay> T error(Class<T> clazz, String errorMsg){
//        Class<?> responsePayClazz = responsePayClassCache.get(clazz.getName());
        try {
//            if(responsePayClazz == null){
//                if(logger.isDebugEnabled()){
//                    logger.debug("没有class，创建新的:{}", clazz.getName());
//                }
//                responsePayClazz = ClassUtils.forName(clazz.getName(), ResponsePay.class.getClassLoader());
//                responsePayClassCache.put(clazz.getName(), responsePayClazz);
//            }
//            Constructor<T> constructor = (Constructor<T>)responsePayClazz.getConstructor();
            Constructor<T> constructor = clazz.getConstructor();
            ResponsePay responsePay = constructor.newInstance();
            responsePay.setStatus(false);
            responsePay.setMessage(errorMsg);
            return (T)responsePay;

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getStatus() {
        return status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 当在环境中不能通过泛型定义结果明细时，可以使用data字段，但这仅在非常阶段使用，<br>
     * 一般都使用result属性。
     * @return
     */
    public Map<String, Object> getData() {
        return data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public void add(String key, Object value){
        this.data.put(key, value);
    }

//    /**
//     * 返回调用结果的具体细节，每个提供商的每个接口，返回的内容都不同；<br>
//     * 该结果会被定义为对象形式，由子业务通过泛型确定格式。
//     * @return
//     */
//    public T getResult() {
//        return result;
//    }
//
//    public void setResult(T result) {
//        this.result = result;
//    }
//
//    private T result = null;

    private boolean status = true;

    private String message = StringUtils.EMPTY_STRING;

    private Map<String, Object> data = new HashMap<>();
}
