package com.walker.pay;

/**
 * 支付提供商定义。<p>
 *     当提供商为银行"Bank"类型时，会存在多个具体银行名称的提供商，这是特殊情况，需要业务加载银行列表。
 * </p>
 * @author 时克英
 * @date 2023-01-12
 */
public enum ServiceProvider {

    /**
     * 微信
     */
    Wechat {
        public String getIndex(){
            return PROVIDER_ID_WECHAT;
        }
        public String getName(){
            return PROVIDER_NAME_WECHAT;
        }
    },

    /**
     * 支付宝
     */
    Alipay {
        public String getIndex(){
            return PROVIDER_ID_ALIPAY;
        }
        public String getName(){
            return PROVIDER_NAME_ALIPAY;
        }
    },

    /**
     * 银联
     */
    UnionPay {
        public String getIndex(){
            return PROVIDER_ID_UNION_PAY;
        }
        public String getName(){
            return PROVIDER_NAME_UNION_PAY;
        }
    },

    /**
     * 通联
     */
    AllinPay {
        public String getIndex(){
            return PROVIDER_ID_ALLIN_PAY;
        }
        public String getName(){
            return PROVIDER_NAME_ALLIN_PAY;
        }
    },

    /**
     * 新大陆
     */
    NewLand {
        public String getIndex(){
            return PROVIDER_ID_NEW_LAND;
        }
        public String getName(){
            return PROVIDER_NAME_NEW_LAND;
        }
    },

    /**
     * 华为
     */
    HuaweiPay {
        public String getIndex(){
            return PROVIDER_ID_HUAWEI_PAY;
        }
        public String getName(){
            return PROVIDER_NAME_HUAWEI_PAY;
        }
    },

    /**
     * 苹果
     */
    ApplePay {
        public String getIndex(){
            return PROVIDER_ID_APPLE_PAY;
        }
        public String getName(){
            return PROVIDER_NAME_APPLE_PAY;
        }
    },

    /**
     * 银行
     */
    Bank {
        public String getIndex(){
            return PROVIDER_ID_BANK;
        }
        public String getName(){
            return PROVIDER_NAME_BANK;
        }
    },

    /**
     * 通商云(通联)支付
     * @date 2023-02-17
     */
    AllinPayCloud {
        public String getIndex(){
            return PROVIDER_ID_ALLINPAY_CLOUD;
        }
        public String getName(){
            return PROVIDER_NAME_ALLINPAY_CLOUD;
        }
    },

    /**
     * 畅联第三方支付（用的转账，类似于下订单）
     * @date 2023-10-25
     */
    PayUnk {
        public String getIndex(){
            return PROVIDER_ID_PAYUNK;
        }
        public String getName(){
            return PROVIDER_NAME_PAYUNK;
        }
    };

    public String getIndex(){
        throw new AbstractMethodError();
    }
    public String getName(){
        throw new AbstractMethodError();
    }

    public static final ServiceProvider getType(String index){
        if(index.equalsIgnoreCase(PROVIDER_ID_WECHAT)){
            return Wechat;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_ALIPAY)){
            return Alipay;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_UNION_PAY)){
            return UnionPay;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_ALLIN_PAY)){
            return AllinPay;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_NEW_LAND)){
            return NewLand;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_HUAWEI_PAY)){
            return HuaweiPay;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_APPLE_PAY)){
            return ApplePay;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_BANK)){
            return Bank;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_ALLINPAY_CLOUD)){
            return AllinPayCloud;
        } else if(index.equalsIgnoreCase(PROVIDER_ID_PAYUNK)){
            return PayUnk;
        } else {
            throw new UnsupportedOperationException("不支持的提供商标识:" + index);
        }
    }

    public static final String PROVIDER_ID_WECHAT = "Wechat";
    public static final String PROVIDER_ID_ALIPAY = "Alipay";
    public static final String PROVIDER_ID_UNION_PAY = "UnionPay";
    public static final String PROVIDER_ID_ALLIN_PAY = "AllinPay";
    public static final String PROVIDER_ID_NEW_LAND = "NewLand";
    public static final String PROVIDER_ID_HUAWEI_PAY = "HuaweiPay";
    public static final String PROVIDER_ID_APPLE_PAY = "ApplePay";
    public static final String PROVIDER_ID_BANK = "Bank";
    public static final String PROVIDER_ID_ALLINPAY_CLOUD = "allinpayCloud";
    public static final String PROVIDER_ID_PAYUNK = "PayUnk";

    public static final String PROVIDER_NAME_WECHAT = "微信";
    public static final String PROVIDER_NAME_ALIPAY = "支付宝";
    public static final String PROVIDER_NAME_UNION_PAY = "银联";
    public static final String PROVIDER_NAME_ALLIN_PAY = "通联";
    public static final String PROVIDER_NAME_NEW_LAND = "新大陆";
    public static final String PROVIDER_NAME_HUAWEI_PAY = "华为";
    public static final String PROVIDER_NAME_APPLE_PAY = "苹果";
    public static final String PROVIDER_NAME_BANK = "银行";
    public static final String PROVIDER_NAME_ALLINPAY_CLOUD = "通商云(通联)";
    public static final String PROVIDER_NAME_PAYUNK = "畅联支付";
}
