package com.walker.pay;

import java.io.Serializable;

/**
 * 分账对象定义，暂未支持多级（仅一级），支持多人分账。<p></p>
 * <pre>
 * Eg：
 * [
 * {
 * "amount": 1000,
 * "fee": 10,
 * "remark": "消费一级分账",
 * "bizUserId": "10000",
 * "splitRuleList": [
 *  {
 * "amount": 500,
 * "fee": 0,
 * "remark": "消费订单二级分账 001",
 * "bizUserId": "10001",
 * "splitRuleList": [
 * 199 / 238
 *  {
 * "amount": 100,
 * "fee": 0,
 * "remark": "消费订单三级分账 003",
 * "bizUserId": "10003"
 *  }
 *  ]
 *  },
 *  {
 * "amount": 200,
 * "fee": 0,
 * "remark": "消费订单二级分账 002",
 * "bizUserId": "10002",
 * "splitRuleList": [
 *  {
 * "amount": 50,
 * "fee": 0,
 * "remark": "消费订单三级分账 004",
 * "bizUserId": "10004"
 *  }
 *  ]
 *  }
 *  ]
 * }
 * ]
 * 以上分账列表表示：
 * ➢ 分给 10000 用户 10 元，并且平台收费 0.1 元（一级分账）；
 * ➢ 10000 用户分给 10001 用户 5 元（二级分账），10001 用户分给 10003 用户 1 元（三级分账）；
 * ➢ 10000 用户分给 10002 用户 2 元（二级分账），10002 用户分给 10004 用户 0.5 元（三级分账）；
 * </pre>
 * @author 时克英
 * @date 2023-04-03
 * @since 通联云支付对接
 */
public class SplitAccount implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[bizUserId=").append(this.bizUserId)
                .append(", accountSetNo=").append(this.accountSetNo)
                .append(", amount=").append(this.amount)
                .append(", fee=").append(this.fee)
                .append(", remark=").append(this.remark)
                .append("]").toString();
    }

    /**
     * 要分账的用户标识，业务对应的用户编号。
     * @return
     */
    public String getBizUserId() {
        return bizUserId;
    }

    public void setBizUserId(String bizUserId) {
        this.bizUserId = bizUserId;
    }

    /**
     * 平台配置的账户集编号，如果对个人则可不填。
     * <pre>
     * 如果向会员分账，不上送，默认为唯一托管账户集。
     * 如果向平台分账，请填写平台的标准账户集编号（不支持 100003-准备金
     * 额度账户集）。
     * </pre>
     * @return
     */
    public String getAccountSetNo() {
        return accountSetNo;
    }

    public void setAccountSetNo(String accountSetNo) {
        this.accountSetNo = accountSetNo;
    }

    /**
     * 分账金额，单位：分
     * @return
     */
    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * 返回手续费，内扣，单位：分
     * @return
     */
    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    /**
     * 分账备注，最长 50 个字符。
     * @return
     */
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

//    private String splitRuleList;

    private String bizUserId;
    private String accountSetNo;
    private Long amount;
    private Long fee = 0L;
    private String remark;
}
