package com.walker.pay.callback;

import com.walker.pay.CallBack;
import com.walker.pay.CallBackException;
import com.walker.pay.NotifyValue;
import com.walker.pay.Order;
import com.walker.pay.ResponsePay;

/**
 * 订单支付回调定义，业务需要实现该接口完成接收支付通知时，业务的需求处理。
 * @author 时克英
 * @date 2023-01-17
 */
public interface OrderCallBack extends CallBack {

    /**
     * 当生成预下单时，回调接口，通常用于保存预下单记录。
     * @param platformOrder 系统订单
     * @param responsePay 预下单返回响应(第三方需要根据不同支付类型具体解析使用)
     * @date 2023-02-20
     */
    void onOrderPrepare(Order platformOrder, ResponsePay responsePay);

    /**
     * 业务处理支付通知回调方法。
     * @param notifyValue
     * @throws CallBackException
     * @date 2023-01-17
     */
    void onOrderNotify(NotifyValue<?> notifyValue) throws CallBackException;
}
