package com.walker.pay.convertor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Convertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonConvertor<T> implements Convertor<T> {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public T toGenericObject(Object data) {
        if(data == null || StringUtils.isEmpty(data.toString())){
            logger.error("要转换为Json的原始对象不存在: data is required!");
            return null;
        }

        try {
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode(data.toString());
            return this.transferTo(objectNode);
        } catch (Exception e) {
            logger.error("转换为JSON出错，原始数据:{}" + data.toString(), e);
            return null;
//            throw new RuntimeException(e);
        }
    }

    protected abstract T transferTo(ObjectNode objectNode);
}
