package com.walker.pay.response;

import com.walker.pay.PayStatus;
import com.walker.pay.ResponsePay;

/**
 * 支付订单查询，响应结果对象。
 * @author 时克英
 * @date 2023-02-23
 */
public class OrderStatusResponsePay extends ResponsePay {

    @Override
    public String toString(){
        return new StringBuilder("[tradeNo=").append(this.tradeNo)
                .append(", orderId=").append(this.orderId)
                .append(", appId=").append(this.appId)
                .append(", merchantId=").append(this.merchantId)
                .append(", providerPayType=").append(this.providerPayType)
                .append(", payStatus=").append(this.payStatus)
                .append(", paySuccessTime=").append(this.paySuccessTime)
                .append(", totalMoney=").append(this.totalMoney)
                .append(", status=").append(this.getStatus())
                .append(", msg=").append(this.getMessage())
                .append("]").toString();
    }

    /**
     * 第三方订单号，如: 微信、通联生成的订单号
     * @return
     */
    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    /**
     * 系统订单号
     * @return
     */
    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * 接入第三方支付，申请的应用ID。微信会返回
     * @return
     */
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 接入第三方支付，定义的商户号。微信会返回
     * @return
     */
    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    /**
     * 第三方定义的支付类型，微信会返回
     * @return
     */
    public String getProviderPayType() {
        return providerPayType;
    }

    public void setProviderPayType(String providerPayType) {
        this.providerPayType = providerPayType;
    }

    /**
     * 支付状态。
     * <pre>
     *     1.success    支付成功
     *     2.refund     交易成功，发生退款
     *     3.not_pay    未支付
     *     4.closed     已关闭
     *     5.error      交易失败
     *     6.paying     正在支付中
     * </pre>
     * @return
     */
    public PayStatus getPayStatus() {
        return this.payStatus;
    }

    public void setPayStatus(PayStatus orderStatus) {
        this.payStatus = orderStatus;
    }

    /**
     * 成功支付时间
     * @return
     */
    public String getPaySuccessTime() {
        return paySuccessTime;
    }

    public void setPaySuccessTime(String paySuccessTime) {
        this.paySuccessTime = paySuccessTime;
    }

    /**
     * 支付总金额
     * @return
     */
    public long getTotalMoney() {
        return totalMoney;
    }

    public void setTotalMoney(long totalMoney) {
        this.totalMoney = totalMoney;
    }

    /**
     * 用户支付金额，存在优惠券时该值为: 总金额 - 优惠金额。<p></p>
     * 否则与总金额一致。
     * @return
     */
    public long getUserPayMoney() {
        return userPayMoney;
    }

    public void setUserPayMoney(long userPayMoney) {
        this.userPayMoney = userPayMoney;
    }

    // 第三方订单号
    private String tradeNo;
    // 系统订单号
//    private long orderId;
    // 2023-05-22 修改成字符串，在系统间使用字符串，最终支付模块还是long
    private String orderId;

    // 接入第三方支付，申请的应用ID
    private String appId;
    // 接入第三方支付，定义的商户号
    private String merchantId;

    private String providerPayType;
    private PayStatus payStatus;
    private String paySuccessTime;

    private long totalMoney = 0;
    private long userPayMoney = 0;
}
