package com.walker.pay.support;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayStatus;
import com.walker.pay.PayType;
import com.walker.pay.ServiceProvider;
import com.walker.pay.SplitAccount;

import java.util.List;

public class DefaultOrder implements Order {

    private long id = 0;
    private String payDefinitionId = null;
    private String tradeNo = null;
    private PayType payType = null;
    private long totalMoney = 0;
    private String title = null;
    private String nonce = null;
    private String notifyUrl = null;
    private String attach = null;
    private String ip = StringUtils.EMPTY_STRING;

    private ServiceProvider serviceProvider;
    private String version;

    @Override
    public String getIdString() {
//        if(StringUtils.isNotEmpty(this.idString)){
//            return idString;
//        }
//        return String.valueOf(this.id);
        return idString;
    }

    public void setIdString(String idString) {
//        if(this.id > 0){
//            throw new IllegalArgumentException("id已经设置，不能再次设置id字符串!");
//        }
//        if(StringUtils.isNumeric(idString)){
//            this.id = Long.parseLong(idString);
//        }
        this.idString = idString;
    }

    private String idString;

    public void setId(long id) {
        if(StringUtils.isNotEmpty(this.idString)){
            throw new IllegalArgumentException("idString已经设置，无需重复设置id");
        }
        this.id = id;
    }

    /**
     * 订单不用再设置'支付定义ID'，由 <cod>PayEngineManager</cod> 根据 ServiceProvider 和 PayType 查找获得。
     * @param payDefinitionId
     * @date 2023-02-20
     * @date 2023-02-23 在查询订单状态时，需要从数据库获取支付定义信息。
     */
    public void setPayDefinitionId(String payDefinitionId) {
        this.payDefinitionId = payDefinitionId;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }

    public void setPayType(PayType payType) {
        this.payType = payType;
    }

    public void setTotalMoney(long totalMoney) {
        this.totalMoney = totalMoney;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setServiceProvider(ServiceProvider serviceProvider){
        this.serviceProvider = serviceProvider;
    }
    public void setVersion(String version){
        this.version = version;
    }

    private long createTime = 0;

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getPayDefinitionId() {
        return this.payDefinitionId;
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getTradeNo() {
        return this.tradeNo;
    }

    @Override
    public PayType getPayType() {
        return this.payType;
    }

    @Override
    public long getTotalMoney() {
        return this.totalMoney;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    @Override
    public String getAttach() {
        return this.attach;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    @Override
    public long getFee() {
        return this.fee;
    }

    @Override
    public String getBuyerId() {
        return this.buyerId;
    }

    @Override
    public String getReceiverId() {
        return this.receiverId;
    }

    @Override
    public PayStatus getPayStatus() {
        return this.payStatus;
    }

    @Override
    public List<SplitAccount> getSplitAccountList() {
        return this.splitAccountList;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setFee(long fee) {
        this.fee = fee;
    }

    public void setBuyerId(String buyerId) {
        this.buyerId = buyerId;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public void setPayStatus(PayStatus payStatus) {
        this.payStatus = payStatus;
    }

    public void setSplitAccountList(List<SplitAccount> splitAccountList) {
        this.splitAccountList = splitAccountList;
    }

    private List<SplitAccount> splitAccountList;
    private PayStatus payStatus = null;
    private String deviceInfo;
    private long fee = 0;
    private String buyerId;
    private String receiverId;

    @Override
    public String toString(){
        return new StringBuilder("[id=").append(this.id)
                .append(", tradeNo=").append(this.tradeNo)
                .append(", payType=").append(this.payType)
                .append(", totalMoney=").append(this.totalMoney)
                .append(", title=").append(this.title)
                .append(", payDefinitionId=").append(this.payDefinitionId)
                .append(", buyerId=").append(this.buyerId)
                .append(", receiverId=").append(this.receiverId)
                .append(", idString=").append(this.idString)
                .append("]").toString();
    }
}
