package com.walker.pay.support;

import com.walker.pay.AbstractPayEngineProvider;
import com.walker.pay.CallBackException;
import com.walker.pay.NotifyValue;
import com.walker.pay.Order;
import com.walker.pay.ResponsePay;

public abstract class SimplePayEngineProvider extends AbstractPayEngineProvider {

    @Override
    protected void savePrepareOrder(Order platformOrder, ResponsePay responsePay) {
        if(this.logger.isDebugEnabled()){
            logger.debug("保存订单:{}", platformOrder);
        }
        this.checkOrderCallback();
        this.getOrderCallback().onOrderPrepare(platformOrder, responsePay);
    }

    @Override
    protected void onNotifyOrder(NotifyValue<?> notifyValue) throws Exception {
//        logger.info("暂未实现: onNotifyOrder()...");
        this.checkOrderCallback();
        try {
            this.getOrderCallback().onOrderNotify(notifyValue);
        } catch (CallBackException e) {
            logger.error("订单支付通知回调错误:{}", notifyValue);
            throw new CallBackException("", e);
        }
    }

    private void checkOrderCallback(){
        if(this.getOrderCallback() == null){
            throw new IllegalArgumentException("OrderCallback 未配置，无法执行订单操作! payEngineProvider = " + this.getClass().getName());
        }
    }
}
