package com.walker.pay.support.allinpaycloud;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.support.DefaultOrder;

/**
 * 支付订单: 支付宝JS支付（生活号）——收银宝
 * @date 2023-02-27
 */
public class AlipayServiceOrder extends DefaultOrder {

    public String getLimitPay() {
        return limitPay;
    }

    /**
     * <pre>
     * 非贷记卡：no_credit
     * 若该字段不传，则默认为借、贷记卡；
     * </pre>
     * @param limitPay
     */
    public void setLimitPay(String limitPay) {
        this.limitPay = limitPay;
    }

    public String getAcct() {
        return acct;
    }

    /**
     * 支付宝JS支付user_id——支付宝分配
     * @param acct
     */
    public void setAcct(String acct) {
        this.acct = acct;
    }

//    public long getAmount() {
//        return amount;
//    }
//
//    /**
//     * 支付金额, 单位：分
//     * @param amount
//     */
//    public void setAmount(long amount) {
//        this.amount = amount;
//    }

    public String getExtendParams() {
        return extendParams;
    }

    /**
     * 渠道拓展参数，最长1000字符
     * @param extendParams
     */
    public void setExtendParams(String extendParams) {
        this.extendParams = extendParams;
    }

    public String getBenefitdetail() {
        return benefitdetail;
    }

    /**
     * 优惠信息，benefitdetail的json字符串,注意是String，支付宝智慧门店，详情
     * @param benefitdetail
     */
    public void setBenefitdetail(String benefitdetail) {
        this.benefitdetail = benefitdetail;
    }

    public Long getFqnum() {
        return fqnum;
    }

    /**
     * <pre>
     * 花呗分期（暂只支持支付宝花呗分期）
     * 3-花呗分期3期
     * 6-花呗分期6期
     * 12-花呗分期12期
     * </pre>
     * @param fqnum
     */
    public void setFqnum(Long fqnum) {
        this.fqnum = fqnum;
    }

    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCertType() {
        return certType;
    }

    public void setCertType(long certType) {
        this.certType = certType;
    }

    private String idNo;
    private String name;
    private long certType = 1;
    private String limitPay = StringUtils.EMPTY_STRING;
    private String acct;
//    private long amount = 0;
    private String extendParams;
    private String benefitdetail;
    private Long fqnum = null;
}
