package com.walker.pay.support.allinpaycloud;

import com.walker.pay.support.DefaultOrder;

/**
 * 微信扫码支付，通过请求第三方，生成支付二维码。
 * @author 时克英
 * @date 2023-03-01
 */
public class ScanWechatOrder extends DefaultOrder {

    /**
     * 渠道拓展参数，最长1000字符，可选
     * @return
     */
    public String getExtendParams() {
        return extendParams;
    }

    public void setExtendParams(String extendParams) {
        this.extendParams = extendParams;
    }

    /**
     * <pre>
     * 非贷记卡：no_credit
     * 借、贷记卡：””，需要传空字符串，不能不传
     * </pre>
     * @return
     */
    public String getLimitPay() {
        return limitPay;
    }

    public void setLimitPay(String limitPay) {
        this.limitPay = limitPay;
    }

    /**
     * 证件号，可选
     * @return
     */
    public String getIdNo() {
        return idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    /**
     * 付款人姓名，可选
     * @return
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <pre>
     * 证件类型
     * 仅支持“1-身份证”
     * </pre>
     * @return
     */
    public long getCertType() {
        return certType;
    }

    public void setCertType(long certType) {
        this.certType = certType;
    }

    private String extendParams;
    private String limitPay = "no_credit";
    private String idNo;
    private String name;
    private long certType = 1;
}
