package com.walker.pay.support.allinpaycloud;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.support.DefaultOrder;

/**
 * 订单类型: 微信JS支付（公众号）——收银宝
 * @author 时克英
 * @date 2023-02-27
 */
public class WechatJsOrder extends DefaultOrder {

    public String getLimitPay() {
        return limitPay;
    }

    /**
     * <pre>
     * 非贷记卡：no_credit
     * 借、贷记卡：””，需要传空字符串，不能不传
     * </pre>
     * @param limitPay
     */
    public void setLimitPay(String limitPay) {
        this.limitPay = limitPay;
    }

    public String getSubAppid() {
        return subAppid;
    }

    /**
     * 微信公众号支付appid 参数
     * 当商户有多个小程序或公众号时接口指定上送
     * @param subAppid
     */
    public void setSubAppid(String subAppid) {
        this.subAppid = subAppid;
    }

    public String getAcct() {
        return acct;
    }

    /**
     * 微信JS支付openid——微信分配
     * @param acct
     */
    public void setAcct(String acct) {
        this.acct = acct;
    }

//    public long getAmount() {
//        return amount;
//    }
//    /**
//     * 支付金额
//     * 单位：分
//     * @param amount
//     */
//    public void setAmount(long amount) {
//        this.amount = amount;
//    }

    public String getExtendParams() {
        return extendParams;
    }

    /**
     * <pre>
     * 渠道拓展参数，最长1000字符
     * </pre>
     * @param extendParams
     */
    public void setExtendParams(String extendParams) {
        this.extendParams = extendParams;
    }

    public String getGoods_tag() {
        return goods_tag;
    }

    /**
     * <pre>
     * 订单支付标识，订单优惠标记，
     * 用于区分订单是否可以享受优惠,字段内容在微信后台配置券时进行设置，只对微信支付有效
     * </pre>
     * @param goods_tag
     */
    public void setGoods_tag(String goods_tag) {
        this.goods_tag = goods_tag;
    }

    public String getBenefitdetail() {
        return benefitdetail;
    }

    /**
     * 优惠信息，benefitdetail的json字符串,注意是String，微信单品优惠，详情, JsonObject
     * @param benefitdetail
     */
    public void setBenefitdetail(String benefitdetail) {
        this.benefitdetail = benefitdetail;
    }

    public String getChnlstoreid() {
        return chnlstoreid;
    }

    /**
     * 渠道门店号--商户在支付渠道端的门店编号
     * @param chnlstoreid
     */
    public void setChnlstoreid(String chnlstoreid) {
        this.chnlstoreid = chnlstoreid;
    }

    public String getSubbranch() {
        return subbranch;
    }

    /**
     * 门店号
     * @param subbranch
     */
    public void setSubbranch(String subbranch) {
        this.subbranch = subbranch;
    }

    public String getIdNo() {
        return idNo;
    }

    /**
     * 证件号
     * @param idNo
     */
    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public String getName() {
        return name;
    }

    /**
     * 付款人姓名
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    public long getCertType() {
        return certType;
    }

    /**
     * 证件类型, 仅支持“1-身份证”
     * @param certType
     */
    public void setCertType(long certType) {
        this.certType = certType;
    }

    private String chnlstoreid;
    private String subbranch;
    private String idNo;
    private String name;
    private long certType = 1;
    private String limitPay = StringUtils.EMPTY_STRING;
    private String subAppid = null;
    private String acct;
//    private long amount = 0;
    private String extendParams;
    private String goods_tag;
    private String benefitdetail;
}
