/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.OrderGenerator;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.exception.OrderException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOrderGenerator
implements OrderGenerator {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ResponsePay generate(String providerPayType, Order platformOrder, Map<String, Variable> configuration) throws OrderException {
        try {
            return this.invoke(providerPayType, platformOrder, configuration);
        }
        catch (Exception ex) {
            throw new OrderException(String.valueOf(platformOrder.getId()), ex.getMessage(), ex);
        }
    }

    @Override
    public ResponsePay generate(PayContext payContext, Order platformOrder) throws OrderException {
        try {
            return this.invoke(payContext, platformOrder);
        }
        catch (Exception ex) {
            throw new OrderException(String.valueOf(platformOrder.getId()), ex.getMessage(), ex);
        }
    }

    protected abstract ResponsePay invoke(PayContext var1, Order var2);

    @Deprecated
    protected abstract ResponsePay invoke(String var1, Order var2, Map<String, Variable> var3);
}

