/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.PayContext;
import com.walker.pay.PayDefinition;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPayContext
implements PayContext {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String providerPayType = null;
    private Map<String, Variable> configuration = new HashMap<String, Variable>(8);
    private PayDefinition payDefinition;

    @Override
    public String getProviderPayType() {
        return this.providerPayType;
    }

    @Override
    public PayDefinition getPayDefinition() {
        return this.payDefinition;
    }

    @Override
    public Variable getConfigVariable(String key) {
        if (!this.configuration.containsKey(key)) {
            this.logger.error("\u652f\u4ed8\u53c2\u6570\u672a\u627e\u5230:{}", (Object)key);
            return null;
        }
        return this.configuration.get(key);
    }

    @Override
    public void setConfigVariable(Variable variable) {
        if (this.configuration.containsKey(variable.getId())) {
            this.logger.warn("\u914d\u7f6e\u53c2\u6570\u5df2\u5b58\u5728\uff0c\u91cd\u590d\u8bbe\u7f6e\u4f1a\u8986\u76d6\u4e4b\u524d\u6570\u636e\uff0cid={}, \u65b0\u8bbe\u7f6e\u503c={}", (Object)variable.getId(), (Object)variable.toString());
        }
        this.configuration.put(variable.getId(), variable);
    }

    public void setPayDefinition(PayDefinition payDefinition) {
        this.payDefinition = payDefinition;
    }

    public void setProviderPayType(String providerPayType) {
        this.providerPayType = providerPayType;
    }
}

