/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Convertor;
import com.walker.pay.NotifyValue;
import com.walker.pay.PayChannel;
import com.walker.pay.PayDefinition;
import com.walker.pay.ServiceProvider;
import com.walker.pay.callback.OrderCallBack;
import com.walker.pay.util.PayDefinitionUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractPayDefinition
implements PayDefinition {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String id;
    private String name;
    private ServiceProvider serviceProvider;
    private String version;
    private PayChannel payChannel;
    private boolean enabled = true;
    private Map<String, Variable> configuration;
    private String payEngineProviderClass;
    private OrderCallBack orderCallback;
    private Convertor<NotifyValue<?>> orderNotifyConvertor = null;
    private String orderNotifyConvertorClass;

    @Override
    public String getOrderNotifyConvertorClass() {
        return this.orderNotifyConvertorClass;
    }

    public void setOrderNotifyConvertorClass(String orderNotifyConvertorClass) {
        this.orderNotifyConvertorClass = orderNotifyConvertorClass;
    }

    @Override
    public Convertor<NotifyValue<?>> getOrderNotifyConvertor() {
        return this.orderNotifyConvertor;
    }

    public void setOrderNotifyConvertor(Convertor<NotifyValue<?>> orderNotifyConvertor) {
        this.orderNotifyConvertor = orderNotifyConvertor;
    }

    @Override
    public OrderCallBack getOrderCallback() {
        return this.orderCallback;
    }

    public void setOrderCallback(OrderCallBack orderCallback) {
        this.orderCallback = orderCallback;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPayChannel(PayChannel payChannel) {
        this.payChannel = payChannel;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setConfiguration(Map<String, Variable> configuration) {
        this.configuration = configuration;
    }

    public void setPayEngineProviderClass(String clazz) {
        this.payEngineProviderClass = clazz;
    }

    @Override
    public String getId() {
        if (StringUtils.isNotEmpty((String)this.id)) {
            return this.id;
        }
        if (this.serviceProvider == null || StringUtils.isEmpty((String)this.version)) {
            throw new IllegalArgumentException("PayDefinition\u5bf9\u8c61\u672a\u8bbe\u7f6e\u5c5e\u6027: serviceProvider \u6216 version");
        }
        this.id = PayDefinitionUtils.getPayDefinitionId(this.serviceProvider, this.version);
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public PayChannel getPayChannel() {
        return this.payChannel;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public Map<String, Variable> getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getPayEngineProviderClass() {
        return this.payEngineProviderClass;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

