/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayDefinition;
import com.walker.pay.PayEngineManager;
import com.walker.pay.PayEngineNotFoundException;
import com.walker.pay.PayEngineProvider;
import com.walker.pay.PayType;
import com.walker.pay.ResponsePay;
import com.walker.pay.ServiceProvider;
import com.walker.pay.exception.NotifyException;
import com.walker.pay.exception.OrderException;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.util.PayDefinitionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPayEngineManager
implements PayEngineManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, PayDefinition> payDefinitionMap = new HashMap<String, PayDefinition>();
    private final Map<String, PayEngineProvider> payEngineProviderMap = new HashMap<String, PayEngineProvider>();
    private Map<String, Variable> configuration = null;

    public Map<String, Variable> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, Variable> configuration) {
        if (configuration == null || configuration.size() == 0) {
            this.logger.warn("\u652f\u4ed8\u5f15\u64ce\u914d\u7f6e\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0d\u9700\u8981\u53c2\u6570\u3002");
        }
        this.configuration = configuration;
        this.logger.info("setConfiguration:{}", this.configuration);
    }

    @Override
    public void loadPayDefinitionList() {
        List<PayDefinition> list = this.acquirePayDefinitionList();
        if (StringUtils.isEmptyList(list)) {
            this.logger.warn("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55'\u652f\u4ed8\u5b9a\u4e49'\u96c6\u5408, \u65e0\u6cd5\u4f7f\u7528\u652f\u4ed8\u529f\u80fd!");
            return;
        }
        PayEngineProvider payEngineProvider = null;
        for (PayDefinition pd : list) {
            try {
                if (!pd.getEnabled()) {
                    this.logger.warn("\u652f\u4ed8\u5b9a\u4e49\u88ab\u7981\u7528\uff0c\u65e0\u6cd5\u4f7f\u7528:" + pd.getName());
                    continue;
                }
                payEngineProvider = this.acquirePayEngineProvider(pd);
                if (payEngineProvider == null) {
                    this.logger.error("acquirePayEngineProvider()\u5f97\u5230\u7a7a\u7684\u5f15\u64ce\u5bf9\u8c61!");
                    continue;
                }
                this.payEngineProviderMap.put(pd.getId(), payEngineProvider);
                this.payDefinitionMap.put(pd.getId(), pd);
                this.logger.info("\u52a0\u8f7d\u4e86\u4e00\u4e2a'PayEngineProvider': " + pd.getName() + ", id=" + pd.getId());
            }
            catch (PayEngineNotFoundException e) {
                this.logger.error("\u83b7\u53d6\u652f\u4ed8\u5f15\u64ce\u9519\u8bef\uff0c\u672a\u627e\u5230\u9700\u8981\u7684\u5bf9\u8c61: " + pd.getId());
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public PayDefinition getPayDefinition(String payDefinitionId) {
        PayDefinition pd = this.payDefinitionMap.get(payDefinitionId);
        if (pd == null) {
            this.logger.warn("\u672a\u627e\u5230\u652f\u4ed8\u5b9a\u4e49\u5bf9\u8c61, id=" + payDefinitionId);
        }
        return pd;
    }

    @Override
    public List<PayEngineProvider> getPayEngineProviderList() {
        if (this.payEngineProviderMap.size() == 0) {
            return null;
        }
        ArrayList<PayEngineProvider> resultList = new ArrayList<PayEngineProvider>(8);
        for (PayEngineProvider payEngineProvider : this.payEngineProviderMap.values()) {
            resultList.add(payEngineProvider);
        }
        return resultList;
    }

    @Override
    public PayEngineProvider getPayEngineProvider(String payDefinitionId) {
        PayEngineProvider payEngineProvider = this.payEngineProviderMap.get(payDefinitionId);
        if (payEngineProvider == null) {
            this.logger.warn("\u672a\u627e\u5230\u652f\u4ed8\u5f15\u64ce\u5bf9\u8c61, id=" + payDefinitionId);
        }
        return payEngineProvider;
    }

    @Override
    public PayEngineProvider getPayEngineProvider(ServiceProvider serviceProvider, String version, PayType payType) {
        String payDefinitionId = PayDefinitionUtils.getPayDefinitionId(serviceProvider, version);
        PayEngineProvider payEngineProvider = this.payEngineProviderMap.get(payDefinitionId);
        if (payEngineProvider == null) {
            this.logger.warn("\u672a\u627e\u5230\u652f\u4ed8\u5f15\u64ce\u5bf9\u8c61, id=" + payDefinitionId + ", provider=" + serviceProvider.getName() + ", version=" + version);
        }
        return payEngineProvider;
    }

    @Override
    public List<PayEngineProvider> getPayEngineProviderList(ServiceProvider serviceProvider) {
        if (serviceProvider == null) {
            throw new IllegalArgumentException("serviceProvider \u53c2\u6570\u5fc5\u987b\u63d0\u4f9b");
        }
        if (this.payEngineProviderMap.size() == 0) {
            return null;
        }
        ArrayList<PayEngineProvider> resultList = new ArrayList<PayEngineProvider>(2);
        for (PayEngineProvider payEngineProvider : this.payEngineProviderMap.values()) {
            if (payEngineProvider.getServiceProvider() != serviceProvider) continue;
            resultList.add(payEngineProvider);
        }
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResponsePay generatePrepareOrder(Order platformOrder) throws OrderException {
        if (platformOrder == null) {
            throw new IllegalArgumentException("platformOrder is required!");
        }
        if (platformOrder.getServiceProvider() == null) {
            throw new IllegalArgumentException("\u63d0\u4f9b\u5546\u4e0d\u80fd\u4e3a\u7a7a: serviceProvider is required!");
        }
        if (platformOrder.getPayType() == null) {
            throw new IllegalArgumentException("\u652f\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a: payType is required!");
        }
        PayEngineProvider payEngineProvider = null;
        if (StringUtils.isEmpty((String)platformOrder.getVersion())) {
            this.logger.warn("\u8ba2\u5355\u672a\u4f20\u5165'version'\u5c5e\u6027, \u9700\u8981\u6839\u636e'ServiceProvider'\u67e5\u8be2\u662f\u5426\u5b58\u5728\u591a\u4e2a\u63d0\u4f9b\u8005:" + platformOrder.getServiceProvider());
            List<PayEngineProvider> payEngineProviders = this.getPayEngineProviderList(platformOrder.getServiceProvider());
            if (StringUtils.isEmptyList(payEngineProviders)) {
                this.logger.error("\u6839\u636e'serviceProvider'\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u652f\u4ed8\u5f15\u64ce\u63d0\u4f9b\u8005:" + platformOrder.getServiceProvider());
            } else {
                if (payEngineProviders.size() != 1) throw new IllegalArgumentException("\u8ba2\u5355\u6ca1\u6709\u63d0\u4f9b\u7248\u672c\u53f7\uff0c\u800c\u4e14\u8be5\u63d0\u4f9b\u8005\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u4f20\u5165\u7248\u672c\u53f7\uff0cserviceProvider=" + platformOrder.getServiceProvider());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u8be5'serviceProvider'\u4e0b\u53ea\u5b58\u5728\u4e00\u4e2a\u63d0\u4f9b\u8005:" + platformOrder.getServiceProvider());
                }
                payEngineProvider = payEngineProviders.get(0);
            }
        } else {
            payEngineProvider = this.getPayEngineProvider(platformOrder.getServiceProvider(), platformOrder.getVersion(), platformOrder.getPayType());
        }
        if (payEngineProvider != null) return payEngineProvider.generatePrepareOrder(platformOrder);
        throw new IllegalArgumentException("PayEngineProvider not found:" + platformOrder.getServiceProvider() + ", " + platformOrder.getVersion());
    }

    @Override
    public String notifyOrder(String payDefinitionId, Object notifyData) throws NotifyException {
        if (StringUtils.isEmpty((String)payDefinitionId)) {
            return "payDefinitionId \u4e3a\u7a7a!";
        }
        PayEngineProvider payEngineProvider = this.getPayEngineProvider(payDefinitionId);
        if (payEngineProvider == null) {
            return "\u672a\u627e\u5230\u652f\u4ed8\u5f15\u64ce\uff0cpayDefinition:" + payDefinitionId;
        }
        payEngineProvider.notifyOrder(notifyData);
        return null;
    }

    @Override
    public String generateNotifyResponse(String payDefinitionId, boolean success) {
        if (StringUtils.isEmpty((String)payDefinitionId)) {
            throw new IllegalArgumentException("payDefinitionId is acquired!");
        }
        PayEngineProvider payEngineProvider = this.getPayEngineProvider(payDefinitionId);
        if (payEngineProvider == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u652f\u4ed8\u5f15\u64ce\uff0cpayDefinition:" + payDefinitionId);
        }
        return payEngineProvider.generateNotifyResponse(success);
    }

    @Override
    public OrderStatusResponsePay searchOrderStatus(String orderId) {
        if (StringUtils.isEmpty((String)orderId)) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u8ba2\u5355\u7f16\u53f7");
        }
        Order order = this.acquireOrder(orderId);
        if (order == null) {
            this.logger.error("\u7cfb\u7edf\u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderId={}", (Object)orderId);
            return null;
        }
        String payDefinitionId = order.getPayDefinitionId();
        if (StringUtils.isEmpty((String)payDefinitionId)) {
            throw new IllegalStateException("\u8be5\u8ba2\u5355\u672a\u5173\u8054\u4efb\u4f55\u652f\u4ed8\u5f15\u64ce\uff0c\u65e0\u6cd5\u7ee7\u7eed\u67e5\u8be2\u8ba2\u5355\u72b6\u6001: payDefinitionId \u4e3a\u7a7a\uff0corderId=" + orderId);
        }
        PayEngineProvider payEngineProvider = this.getPayEngineProvider(payDefinitionId);
        if (payEngineProvider == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u652f\u4ed8\u5f15\u64ce\uff0cpayDefinition:" + payDefinitionId);
        }
        return payEngineProvider.searchOrderStatus(order);
    }

    protected abstract List<PayDefinition> acquirePayDefinitionList();

    protected abstract PayEngineProvider acquirePayEngineProvider(PayDefinition var1) throws PayEngineNotFoundException;

    protected abstract Order acquireOrder(String var1);
}

