/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.AbstractPayContext;
import com.walker.pay.CallBackException;
import com.walker.pay.Convertor;
import com.walker.pay.NotifyValue;
import com.walker.pay.Order;
import com.walker.pay.OrderGenerator;
import com.walker.pay.OrderStatusQuery;
import com.walker.pay.PayChannel;
import com.walker.pay.PayContext;
import com.walker.pay.PayDefinition;
import com.walker.pay.PayEngineProvider;
import com.walker.pay.PayType;
import com.walker.pay.ResponsePay;
import com.walker.pay.ServiceProvider;
import com.walker.pay.callback.OrderCallBack;
import com.walker.pay.exception.NotifyException;
import com.walker.pay.exception.OrderException;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.support.DefaultOrder;
import com.walker.pay.util.PayDefinitionUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPayEngineProvider
implements PayEngineProvider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Variable> configuration = null;
    private ServiceProvider serviceProvider;
    private String version;
    private PayChannel payChannel;
    private Convertor<NotifyValue<?>> orderNotifyConvertor = null;
    private OrderCallBack orderCallback;
    private PayDefinition payDefinition;

    public Map<String, Variable> getConfiguration() {
        return this.configuration;
    }

    public void setOrderNotifyConvertor(Convertor<NotifyValue<?>> orderNotifyConvertor) {
        this.orderNotifyConvertor = orderNotifyConvertor;
    }

    @Override
    public void setConfiguration(Map<String, Variable> configuration) {
        if (configuration == null || configuration.size() == 0) {
            this.logger.warn("\u652f\u4ed8\u5f15\u64ce\u914d\u7f6e\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e0d\u9700\u8981\u53c2\u6570\u3002provider=" + this.getServiceProvider().getName() + ", version=" + this.getVersion());
        }
        this.configuration = configuration;
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public PayChannel getPayChannel() {
        return this.payChannel;
    }

    @Override
    public String getPayDefinitionId() {
        return PayDefinitionUtils.getPayDefinitionId(this.serviceProvider, this.version);
    }

    public void setPayChannel(PayChannel payChannel) {
        this.payChannel = payChannel;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public String getProviderPayType(PayType payType) {
        String thirdPayType = this.acquireProviderPayType(this.serviceProvider, payType, this.payChannel);
        if (StringUtils.isEmpty((String)thirdPayType)) {
            this.logger.warn("\u7528\u6237\u5b9e\u73b0\u652f\u4ed8\u7c7b\u578b\u83b7\u53d6\u4e3a\u7a7a: acquireProviderPayType = null, payType = " + payType);
        }
        return thirdPayType;
    }

    protected abstract String acquireProviderPayType(ServiceProvider var1, PayType var2, PayChannel var3);

    @Deprecated
    protected abstract OrderGenerator acquireOrderGenerator(String var1, Order var2, Map<String, Variable> var3);

    protected abstract void savePrepareOrder(Order var1, ResponsePay var2);

    @Override
    public ResponsePay generatePrepareOrder(Order platformOrder) throws OrderException {
        if (platformOrder == null) {
            throw new IllegalArgumentException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a: platformOrder is required!");
        }
        if (StringUtils.isEmpty((String)platformOrder.getNotifyUrl())) {
            throw new IllegalArgumentException("\u652f\u4ed8\u56de\u8c03\u5730\u5740\u672a\u8bbe\u7f6e: notifyUrl is required!");
        }
        if (platformOrder.getId() <= 0L) {
            throw new IllegalArgumentException("\u8ba2\u5355ID\u5fc5\u987b\u8bbe\u7f6e: id is required!");
        }
        ((DefaultOrder)platformOrder).setVersion(this.getVersion());
        String providerPayType = this.acquireProviderPayType(this.serviceProvider, platformOrder.getPayType(), this.payChannel);
        if (StringUtils.isEmpty((String)providerPayType)) {
            throw new IllegalArgumentException("\u8bf7\u5b9e\u73b0\u65b9\u6cd5 'acquireProviderPayType', payType = " + platformOrder.getPayType());
        }
        String orderId = String.valueOf(platformOrder.getId());
        OrderGenerator orderGenerator = this.acquireOrderGenerator(providerPayType, platformOrder, this.configuration);
        if (orderGenerator == null) {
            throw new OrderException(orderId, "\u4e0d\u652f\u6301\u4f9b\u5e94\u5546\u7684\u8ba2\u5355\u652f\u4ed8\u7c7b\u578b:" + providerPayType + ", payType=" + platformOrder.getPayType(), null);
        }
        PayContext payContext = this.acquirePayContext(providerPayType, platformOrder, this.configuration);
        if (payContext == null) {
            this.logger.error("PayContext\u521b\u5efa\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u64cd\u4f5c\u3002platformOrder={}", (Object)platformOrder);
            return null;
        }
        AbstractPayContext abstractPayContext = (AbstractPayContext)payContext;
        abstractPayContext.setProviderPayType(providerPayType);
        abstractPayContext.setPayDefinition(this.getPayDefinition());
        try {
            ResponsePay responsePay = orderGenerator.generate(payContext, platformOrder);
            if (responsePay == null) {
                this.logger.error("\u9884\u8ba2\u5355\u751f\u6210\u4e3a\u7a7a: responseValue is null! platformOrder={}", (Object)platformOrder);
                return null;
            }
            if (responsePay.getStatus()) {
                this.savePrepareOrder(platformOrder, responsePay);
            } else {
                this.logger.warn("\u9884\u4e0b\u5355\u7b2c\u4e09\u65b9\u8fd4\u56de\u5931\u8d25: " + responsePay.getMessage());
            }
            return responsePay;
        }
        catch (OrderException e) {
            this.logger.error("\u8ba2\u5355\u751f\u6210\u5f02\u5e38:" + e.getMessage() + ", orderId=" + e.getOrderId(), (Throwable)((Object)e));
            throw e;
        }
    }

    @Override
    public void notifyOrder(Object notifyData) throws NotifyException {
        if (notifyData == null || StringUtils.isEmpty((String)notifyData.toString())) {
            throw new NotifyException("", "\u8ba2\u5355\u901a\u77e5\u6570\u636e\u4e3a\u7a7a", null);
        }
        if (this.orderNotifyConvertor == null) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8bbe\u7f6e orderNotifyConvertor \u5bf9\u8c61.");
        }
        try {
            boolean signSuccess = this.verifySign(notifyData);
            if (!signSuccess) {
                throw new NotifyException("", "\u7b7e\u540d\u9a8c\u8bc1\u672a\u901a\u8fc7\uff0csource=" + notifyData, null);
            }
        }
        catch (Exception e) {
            throw new NotifyException("", "\u9a8c\u8bc1\u7b7e\u540d\u5f02\u5e38:" + e.getMessage(), e);
        }
        NotifyValue<?> notifyValue = null;
        try {
            notifyValue = this.orderNotifyConvertor.toGenericObject(notifyData);
        }
        catch (Exception ex) {
            throw new NotifyException("", "notifyValue\u8f6c\u6362\u9519\u8bef:" + ex.getMessage(), ex);
        }
        if (notifyValue == null) {
            throw new NotifyException("", "notifyValue \u8f6c\u6362\u4e3a\u7a7a:" + notifyData, null);
        }
        notifyValue.setSource(notifyData);
        notifyValue.setPayChannel(this.payChannel);
        notifyValue.setServiceProvider(this.serviceProvider);
        notifyValue.setVersion(this.version);
        try {
            this.onNotifyOrder(notifyValue);
        }
        catch (Exception ex) {
            if (ex instanceof CallBackException) {
                this.logger.error("\u8ba2\u5355\u901a\u77e5\u5728'\u4e1a\u52a1\u56de\u8c03'\u4e2d\u6267\u884c\u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
            }
            throw new NotifyException(notifyValue.getOrderId(), "\u652f\u4ed8\u901a\u77e5'\u5e73\u53f0\u8c03\u7528'\u5f02\u5e38:" + ex.getMessage(), ex);
        }
    }

    @Override
    public OrderStatusResponsePay searchOrderStatus(Order order) {
        OrderStatusQuery orderStatusQuery = this.acquireOrderStatusQuery(order);
        if (orderStatusQuery == null) {
            throw new IllegalArgumentException("OrderStatusQuery\u4e3a\u7a7a\uff0c\u8bf7\u5b9e\u73b0\u65b9\u6cd5:acquireOrderStatusQuery();");
        }
        try {
            return this.invokeOrderStatus(orderStatusQuery);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException("\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u5f02\u5e38, orderId=" + order.getId() + ", msg=" + ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract boolean verifySign(Object var1) throws Exception;

    protected abstract void onNotifyOrder(NotifyValue<?> var1) throws Exception;

    protected abstract PayContext acquirePayContext(String var1, Order var2, Map<String, Variable> var3);

    protected abstract OrderStatusQuery acquireOrderStatusQuery(Order var1);

    protected abstract OrderStatusResponsePay invokeOrderStatus(OrderStatusQuery var1);

    public PayDefinition getPayDefinition() {
        return this.payDefinition;
    }

    @Override
    public void setPayDefinition(PayDefinition payDefinition) {
        this.payDefinition = payDefinition;
    }

    public OrderCallBack getOrderCallback() {
        return this.orderCallback;
    }

    @Override
    public void setOrderCallback(OrderCallBack orderCallback) {
        this.orderCallback = orderCallback;
    }
}

