/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PayStatus {
    Success{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_SUCCESS;
        }
    }
    ,
    Refund{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_REFUND;
        }
    }
    ,
    NotPay{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_NOT_PAY;
        }
    }
    ,
    Closed{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_CLOSED;
        }
    }
    ,
    Error{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_ERROR;
        }
    }
    ,
    Paying{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_PAYING;
        }
    }
    ,
    Created{

        @Override
        public String getIndex() {
            return PayStatus.INDEX_CREATED;
        }
    };

    public static final String INDEX_SUCCESS = "success";
    public static final String INDEX_REFUND = "refund";
    public static final String INDEX_NOT_PAY = "not_pay";
    public static final String INDEX_CLOSED = "closed";
    public static final String INDEX_ERROR = "error";
    public static final String INDEX_PAYING = "paying";
    public static final String INDEX_CREATED = "created";

    public String getIndex() {
        throw new AbstractMethodError();
    }

    public static PayStatus getType(String index) {
        if (index.equalsIgnoreCase(INDEX_SUCCESS)) {
            return Success;
        }
        if (index.equalsIgnoreCase(INDEX_REFUND)) {
            return Refund;
        }
        if (index.equalsIgnoreCase(INDEX_NOT_PAY)) {
            return NotPay;
        }
        if (index.equalsIgnoreCase(INDEX_ERROR)) {
            return Error;
        }
        if (index.equalsIgnoreCase(INDEX_CLOSED)) {
            return Closed;
        }
        if (index.equalsIgnoreCase(INDEX_PAYING)) {
            return Paying;
        }
        if (index.equalsIgnoreCase(INDEX_CREATED)) {
            return Created;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u652f\u4ed8\u72b6\u6001:" + index);
    }
}

