/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.convertor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Convertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonConvertor<T>
implements Convertor<T> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public T toGenericObject(Object data) {
        if (data == null || StringUtils.isEmpty((String)data.toString())) {
            this.logger.error("\u8981\u8f6c\u6362\u4e3aJson\u7684\u539f\u59cb\u5bf9\u8c61\u4e0d\u5b58\u5728: data is required!");
            return null;
        }
        try {
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)data.toString());
            return this.transferTo(objectNode);
        }
        catch (Exception e) {
            this.logger.error("\u8f6c\u6362\u4e3aJSON\u51fa\u9519\uff0c\u539f\u59cb\u6570\u636e:{}" + data.toString(), (Throwable)e);
            return null;
        }
    }

    protected abstract T transferTo(ObjectNode var1);
}

