package com.walker.pay.allinpay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.allinpay.util.SignUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;
import java.util.TreeMap;

/**
 * 通联: 收银台 --> H5订单提交，返回支付操作网页界面。
 * @author 时克英
 * @date 2023-01-25
 */
public class H5OrderGenerator extends BaseOrderGenerator{

    private RestTemplate restTemplate;

    public H5OrderGenerator(RestTemplate restTemplate){
        this.restTemplate = restTemplate;
    }

    @Override
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        StandardPayContext context = (StandardPayContext) payContext;
        TreeMap<String,String> request = this.toRequest(payContext.getProviderPayType(), platformOrder, context);
        ResponseEntity<String> entity = restTemplate.postForEntity(Constants.URL_ORDER_H5, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'通联H5'订单返回空数据, orderId = " + platformOrder.getId());
        }
        if(entity.getStatusCodeValue() != 200){
            logger.error(entity.getBody());
            throw new RuntimeException("调用'通联H5'http返回错误, orderId = " + platformOrder.getId());
        }

        H5ResponsePay responsePay = new H5ResponsePay();
        responsePay.setHtml(entity.getBody());
        if(this.logger.isDebugEnabled()){
            logger.debug(responsePay.getHtml());
        }
        return responsePay;
    }

    @Deprecated
    @Override
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("该方法已废弃!");
        /*TreeMap<String,String> request = this.toRequest(providerPayType, platformOrder, configuration);
        ResponseEntity<String> entity = restTemplate.postForEntity(Constants.URL_ORDER_H5, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'通联H5'订单返回空数据, orderId = " + platformOrder.getId());
        }
        if(entity.getStatusCodeValue() != 200){
            logger.error(entity.getBody());
            throw new RuntimeException("调用'通联H5'http返回错误, orderId = " + platformOrder.getId());
        }

        H5ResponsePay responsePay = new H5ResponsePay();
        responsePay.setHtml(entity.getBody());
        if(this.logger.isDebugEnabled()){
            logger.debug(responsePay.getHtml());
        }
        return responsePay;*/
    }

    private TreeMap<String,String> toRequest(String providerPayType, Order platformOrder
//            , Map<String, Variable> configuration
            , StandardPayContext context){
        TreeMap<String,String> params = new TreeMap<String,String>();
//        params.put("appid", configuration.get(Constants.CONFIG_KEY_APP_ID).getStringValue());
//        params.put("cusid", configuration.get(Constants.CONFIG_KEY_MCH_ID).getStringValue());
        params.put("appid", context.getAppIdConfig().getStringValue());
        params.put("cusid", context.getMchIdConfig().getStringValue());
        params.put("version", Constants.VERSION);
        params.put("charset", StringUtils.DEFAULT_CHARSET_UTF8);
        params.put("trxamt", String.valueOf(platformOrder.getTotalMoney()));
        params.put("reqsn", String.valueOf(platformOrder.getId()));
        // 临时测试，正式需要改掉
        params.put("returl", Constants.RET_URL);
        params.put("notify_url", platformOrder.getNotifyUrl());
        params.put("body", platformOrder.getTitle());
        params.put("randomstr", platformOrder.getNonce());
        params.put("remark", platformOrder.getAttach());
        params.put("validtime", Constants.VALID_TIME);
        params.put("signtype", this.getSignType());

        String sign = StringUtils.EMPTY_STRING;
        String appKey = StringUtils.EMPTY_STRING;
        if(this.getSignType().equals(Constants.SIGN_TYPE_RSA)){
//            appKey = configuration.get(Constants.CONFIG_KEY_RSA_PRI_KEY).getStringValue();
            appKey = context.getRsaPriKeyConfig().getStringValue();
        } else if(this.getSignType().equals(Constants.SIGN_TYPE_SM2)){
//            appKey = configuration.get(Constants.CONFIG_KEY_SM2_PRI_KEY).getStringValue();
            appKey = context.getSm2PriKeyConfig().getStringValue();
        } else {
//            appKey = configuration.get(Constants.CONFIG_KEY_MD5_KEY).getStringValue();
            appKey = context.getMd5KeyConfig().getStringValue();
        }
        try {
            sign = SignUtils.unionSign(params, appKey, this.getSignType());
            if(this.logger.isDebugEnabled()){
                this.logger.debug(sign);
            }
            params.put("sign", sign);
        } catch (Exception e) {
            throw new RuntimeException("通联支付H5签名错误:" + e.getMessage(), e);
        }
        return params;
    }
}
