package com.walker.pay.allinpay;

public class Constants {

    /**
     * 支付方式: 微信
     */
    public static final String PAY_TYPE_WECHAT = "VSP501";

    /**
     * 支付方式: 微信撤销
     */
    public static final String PAY_TYPE_WECHAT_CANCEL = "VSP502";

    /**
     * 支付方式: 微信退款
     */
    public static final String PAY_TYPE_WECHAT_REFUND = "VSP503";

    /**
     * 支付方式: 支付宝
     */
    public static final String PAY_TYPE_ALIPAY = "VSP511";
    public static final String PAY_TYPE_ALIPAY_CANCEL = "VSP512";
    public static final String PAY_TYPE_ALIPAY_REFUND = "VSP513";

    public static final String CONFIG_KEY_APP_ID = "PAY.TL.APPID";
    public static final String CONFIG_KEY_MCH_ID = "PAY.TL.MCH_ID";
    public static final String CONFIG_KEY_MD5_KEY = "PAY.TL.MD5_KEY";
    public static final String CONFIG_KEY_RSA_PRI_KEY = "PAY.TL.RSA_PRI_KEY";
    public static final String CONFIG_KEY_RSA_PUB_KEY = "PAY.TL.RSA_PUB_KEY";
    public static final String CONFIG_KEY_SM2_PRI_KEY = "PAY.TL.SM2_PRI_KEY";
    public static final String CONFIG_KEY_SM2_PUB_KEY = "PAY.TL.SM2_PUB_KEY";

    public static final String SIGN_TYPE_RSA = "RSA";
    public static final String SIGN_TYPE_SM2 = "SM2";
    public static final String SIGN_TYPE_MD5 = "MD5";

    public static final String URL_ORDER = "https://vsp.allinpay.com/apiweb";
    public static final String URL_ORDER_H5 = "https://vsp.allinpay.com/apiweb/h5unionpay/unionorder";

    public static final String VERSION = "12";

    /**
     * 测试用: 支付成功后跳转到业务指定的页面，目前使用通联提供的测试页面。
     * @date 2023-01-25
     */
    public static final String RET_URL = "https://test.allinpaygd.com/JWeb/reccomparams.jsp";

    /**
     * 订单有效时间，以分为单位，默认为5，超时后不允许支付
     */
    public static final String VALID_TIME = "5";

    public static final String VALUE_APP_ID = "appid";
}
