package com.walker.pay.allinpay.util;

import com.walker.infrastructure.utils.Base64;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.allinpay.Constants;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {

    public static String unionSign(TreeMap<String, String> params, String appKey, String signType) throws Exception {
        params.remove("sign");
        if (signType.equals(Constants.SIGN_TYPE_MD5)) {// 如果是md5则需要把md5的key加入到排序
            params.put("key", appKey);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() != null && entry.getValue().length() > 0) {
                sb.append(entry.getKey()).append(StringUtils.CHAR_EQUALS).append(entry.getValue()).append(StringUtils.CHAR_AND);
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        String sign = StringUtils.EMPTY_STRING;
        if (signType.equals(Constants.SIGN_TYPE_MD5)) {
//            System.out.println(sb.toString());
//            sign = md5(sb.toString().getBytes("UTF-8"));// 记得是md5编码的加签
            sign = MD5.getMessageDigest(sb.toString().getBytes(StringUtils.DEFAULT_CHARSET_UTF8));
            params.remove("key");
        } else if(signType.equals(Constants.SIGN_TYPE_SM2)){
//            System.out.println(sb.toString());
            PrivateKey privateKey = SmUtil.privKeySM2FromBase64Str(appKey);
            sign = SmUtil.signSM3SM2RetBase64(privateKey, params.get(Constants.VALUE_APP_ID), sb.toString().getBytes(StringUtils.DEFAULT_CHARSET_UTF8));//签名
        } else {
//            System.out.println(sb.toString());
            sign = rsaSign(sb.toString(), appKey, StringUtils.DEFAULT_CHARSET_UTF8);
        }
        return sign;
    }

    public static String rsaSign(String content, String privateKey, String charset) throws Exception {
        PrivateKey priKey = getPrivateKeyFromPKCS8(Constants.SIGN_TYPE_RSA,
//                Base64.decodeBase64(privateKey.getBytes()));
                Base64.decode(privateKey.getBytes()));
        return rsaSign(content, priKey, charset);
    }

    public static String rsaSign(String content, byte[] privateKey, String charset) throws Exception {
        PrivateKey priKey = getPrivateKeyFromPKCS8(Constants.SIGN_TYPE_RSA, privateKey);
        return rsaSign(content, priKey, charset);
    }

    public static String rsaSign(String content, PrivateKey priKey, String charset) throws Exception {
        java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");
        signature.initSign(priKey);
        if (StringUtils.isEmpty(charset)) {
            signature.update(content.getBytes());
        } else {
            signature.update(content.getBytes(charset));
        }
        byte[] signed = signature.sign();
        return new String(Base64.encodeBase64(signed));
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, byte[] encodedKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

//    public static String md5(byte[] b) {
//        try {
//            MessageDigest md = MessageDigest.getInstance("MD5");
//            md.reset();
//            md.update(b);
//            byte[] hash = md.digest();
//            StringBuffer outStrBuf = new StringBuffer(32);
//            for (int i = 0; i < hash.length; i++) {
//                int v = hash[i] & 0xFF;
//                if (v < 16) {
//                    outStrBuf.append('0');
//                }
//                outStrBuf.append(Integer.toString(v, 16).toLowerCase());
//            }
//            return outStrBuf.toString();
//        } catch (NoSuchAlgorithmException e) {
//            e.printStackTrace();
//            return new String(b);
//        }
//    }
}
