/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpay;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.allinpay.BaseOrderGenerator;
import com.walker.pay.allinpay.H5ResponsePay;
import com.walker.pay.allinpay.StandardPayContext;
import com.walker.pay.allinpay.util.SignUtils;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class H5OrderGenerator
extends BaseOrderGenerator {
    private RestTemplate restTemplate;

    public H5OrderGenerator(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        StandardPayContext context = (StandardPayContext)payContext;
        TreeMap<String, String> request = this.toRequest(payContext.getProviderPayType(), platformOrder, context);
        ResponseEntity entity = this.restTemplate.postForEntity("https://vsp.allinpay.com/apiweb/h5unionpay/unionorder", request, String.class, new Object[0]);
        if (entity == null) {
            throw new RuntimeException("\u8c03\u7528'\u901a\u8054H5'\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + platformOrder.getId());
        }
        if (entity.getStatusCodeValue() != 200) {
            this.logger.error((String)entity.getBody());
            throw new RuntimeException("\u8c03\u7528'\u901a\u8054H5'http\u8fd4\u56de\u9519\u8bef, orderId = " + platformOrder.getId());
        }
        H5ResponsePay responsePay = new H5ResponsePay();
        responsePay.setHtml((String)entity.getBody());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(responsePay.getHtml());
        }
        return responsePay;
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("\u8be5\u65b9\u6cd5\u5df2\u5e9f\u5f03!");
    }

    private TreeMap<String, String> toRequest(String providerPayType, Order platformOrder, StandardPayContext context) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appid", context.getAppIdConfig().getStringValue());
        params.put("cusid", context.getMchIdConfig().getStringValue());
        params.put("version", "12");
        params.put("charset", "UTF-8");
        params.put("trxamt", String.valueOf(platformOrder.getTotalMoney()));
        params.put("reqsn", String.valueOf(platformOrder.getId()));
        params.put("returl", "https://test.allinpaygd.com/JWeb/reccomparams.jsp");
        params.put("notify_url", platformOrder.getNotifyUrl());
        params.put("body", platformOrder.getTitle());
        params.put("randomstr", platformOrder.getNonce());
        params.put("remark", platformOrder.getAttach());
        params.put("validtime", "5");
        params.put("signtype", this.getSignType());
        String sign = "";
        String appKey = "";
        appKey = this.getSignType().equals("RSA") ? context.getRsaPriKeyConfig().getStringValue() : (this.getSignType().equals("SM2") ? context.getSm2PriKeyConfig().getStringValue() : context.getMd5KeyConfig().getStringValue());
        try {
            sign = SignUtils.unionSign(params, appKey, this.getSignType());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(sign);
            }
            params.put("sign", sign);
        }
        catch (Exception e) {
            throw new RuntimeException("\u901a\u8054\u652f\u4ed8H5\u7b7e\u540d\u9519\u8bef:" + e.getMessage(), e);
        }
        return params;
    }
}

