/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpay.util;

import com.walker.infrastructure.utils.Base64;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.allinpay.util.SmUtil;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    public static String unionSign(TreeMap<String, String> params, String appKey, String signType) throws Exception {
        params.remove("sign");
        if (signType.equals("MD5")) {
            params.put("key", appKey);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() == null || entry.getValue().length() <= 0) continue;
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        String sign = "";
        if (signType.equals("MD5")) {
            sign = MD5.getMessageDigest((byte[])sb.toString().getBytes("UTF-8"));
            params.remove("key");
        } else if (signType.equals("SM2")) {
            PrivateKey privateKey = SmUtil.privKeySM2FromBase64Str(appKey);
            sign = SmUtil.signSM3SM2RetBase64(privateKey, params.get("appid"), sb.toString().getBytes("UTF-8"));
        } else {
            sign = SignUtils.rsaSign(sb.toString(), appKey, "UTF-8");
        }
        return sign;
    }

    public static String rsaSign(String content, String privateKey, String charset) throws Exception {
        PrivateKey priKey = SignUtils.getPrivateKeyFromPKCS8("RSA", Base64.decode((byte[])privateKey.getBytes()));
        return SignUtils.rsaSign(content, priKey, charset);
    }

    public static String rsaSign(String content, byte[] privateKey, String charset) throws Exception {
        PrivateKey priKey = SignUtils.getPrivateKeyFromPKCS8("RSA", privateKey);
        return SignUtils.rsaSign(content, priKey, charset);
    }

    public static String rsaSign(String content, PrivateKey priKey, String charset) throws Exception {
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initSign(priKey);
        if (StringUtils.isEmpty((String)charset)) {
            signature.update(content.getBytes());
        } else {
            signature.update(content.getBytes(charset));
        }
        byte[] signed = signature.sign();
        return new String(Base64.encodeBase64((byte[])signed));
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, byte[] encodedKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }
}

