/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpay.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.jcajce.spec.SM2ParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;

public class SmUtil {
    public static final String ALGORITHM_SM3SM2_BCPROV = "SM3withSM2";
    private static final int SM3withSM2_RS_LEN = 32;

    public static void main(String[] args) throws Exception {
        String appid = "00000156";
        String cusPrivateKey = "MIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgjj4Rk+b0YjwO+UwXofnHf4bK+kaaY5Btkd8nMP2VimmgCgYIKoEcz1UBgi2hRANCAAQqlALW4qGC3bP1x3wo5QsKxaCMEZJ2ODTTwOQ+d8UGU7GoK/y/WMBQWf5upMnFU06p5FxGooXYYoBtldgm03hq";
        String cusPubKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEKpQC1uKhgt2z9cd8KOULCsWgjBGSdjg008DkPnfFBlOxqCv8v1jAUFn+bqTJxVNOqeRcRqKF2GKAbZXYJtN4ag==";
        String tlPubKey = "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE/BnA8BawehBtH0ksPyayo4pmzL/u1FQ2sZcqwOp6bjVqQX4tjo930QAvHZPJ2eez8sCz/RYghcqv4LvMq+kloQ==";
        String blankStr = "\u8bf7\u6c42\u5f85\u7b7e\u540d\u6570\u636e";
        PrivateKey privkey = SmUtil.privKeySM2FromBase64Str(cusPrivateKey);
        String sign = SmUtil.signSM3SM2RetBase64(privkey, appid, blankStr.getBytes("UTF-8"));
        System.out.println(sign);
        String rspBlankStr = "\u8fd4\u56de\u5f85\u9a8c\u7b7e\u6570\u636e";
        String rspSign = "AovBKQGUe0xuJ0ox7FgIIX+yB3DzbudgUsnNvJmDV0IdHZtU2Y8vdeUY1pd2vmPUf08hNgdkoz+4WP/D/ktOcA==";
        PublicKey publicKey = SmUtil.pubKeySM2FromBase64Str(tlPubKey);
        boolean isOk = SmUtil.verifySM3SM2(publicKey, "Allinpay", Base64.decodeBase64((String)rspSign), rspBlankStr.getBytes("UTF-8"));
        System.out.println("\u9a8c\u7b7e\u7ed3\u679c:" + isOk);
    }

    public static String signSM3SM2RetBase64(PrivateKey privateKey, String certid, byte[] data) throws Exception {
        return Base64.encodeBase64String((byte[])SmUtil.signSM3SM2(privateKey, certid, data));
    }

    public static byte[] signSM3SM2(PrivateKey privateKey, String certid, byte[] data) throws Exception {
        SM2ParameterSpec parameterSpec = new SM2ParameterSpec(certid.getBytes());
        Signature signer = Signature.getInstance(ALGORITHM_SM3SM2_BCPROV, "BC");
        signer.setParameter((AlgorithmParameterSpec)parameterSpec);
        signer.initSign(privateKey, new SecureRandom());
        signer.update(data);
        return SmUtil.byteAsn12BytePlain(signer.sign());
    }

    public static boolean verifySM3SM2(PublicKey publicKey, String certid, byte[] signData, byte[] srcData) throws Exception {
        SM2ParameterSpec parameterSpec = new SM2ParameterSpec(certid.getBytes());
        Signature verifier = Signature.getInstance(ALGORITHM_SM3SM2_BCPROV, "BC");
        verifier.setParameter((AlgorithmParameterSpec)parameterSpec);
        verifier.initVerify(publicKey);
        verifier.update(srcData);
        return verifier.verify(SmUtil.bytePlain2ByteAsn1(signData));
    }

    public static PrivateKey privKeySM2FromBase64Str(String keystr) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((String)keystr)));
    }

    public static PublicKey pubKeySM2FromBase64Str(String keystr) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("EC");
        return keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)keystr)));
    }

    private static byte[] bytePlain2ByteAsn1(byte[] data) {
        if (data.length != 64) {
            throw new RuntimeException("err data. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(data, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(data, 32, 64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] byteAsn12BytePlain(byte[] dataAsn1) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)dataAsn1);
        byte[] r = SmUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = SmUtil.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange(rs, 1, 33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill(result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new RuntimeException("err rs: " + Hex.toHexString((byte[])rs));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

