/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpaycloud;

import com.allinpay.sdk.bean.OpenConfig;
import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.OrderGenerator;
import com.walker.pay.OrderStatusQuery;
import com.walker.pay.PayChannel;
import com.walker.pay.PayContext;
import com.walker.pay.PayType;
import com.walker.pay.ServiceProvider;
import com.walker.pay.allinpaycloud.CloudPayContext;
import com.walker.pay.allinpaycloud.RequestNotify;
import com.walker.pay.allinpaycloud.SdkClient;
import com.walker.pay.allinpaycloud.generator.BankCardOrderGenerator;
import com.walker.pay.allinpaycloud.generator.ScanWechatOrderGenerator;
import com.walker.pay.allinpaycloud.generator.WechatJsOrderGenerator;
import com.walker.pay.allinpaycloud.generator.WechatProgramOrderGenerator;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.support.SimplePayEngineProvider;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.client.RestTemplate;

public class DefaultPayEngineProvider
extends SimplePayEngineProvider {
    private SdkClient sdkClient = null;
    private Map<String, OrderGenerator> orderGeneratorMap = new HashMap<String, OrderGenerator>(8);

    public DefaultPayEngineProvider() {
    }

    public DefaultPayEngineProvider(RestTemplate restTemplate) {
    }

    protected String acquireProviderPayType(ServiceProvider serviceProvider, PayType payType, PayChannel payChannel) {
        if (payType == PayType.AllinPayCloud_QUICKPAY_VSP) {
            return "QUICKPAY_VSP";
        }
        if (payType == PayType.AllinPayCloud_WECHAT_PUBLIC) {
            return "WECHAT_PUBLIC";
        }
        if (payType == PayType.AllinPayCloud_ALIPAY_SERVIC) {
            return "ALIPAY_SERVICE";
        }
        if (payType == PayType.AllinPayCloud_WECHATPAY_MINIPROGRAM) {
            return "WECHATPAY_MINIPROGRAM";
        }
        if (payType == PayType.AllinPayCloud_SCAN_WEIXIN) {
            return "SCAN_WEIXIN";
        }
        if (payType == PayType.AllinPayCloud_SCAN_ALIPAY) {
            return "SCAN_ALIPAY";
        }
        if (payType == PayType.AllinPayCloud_COUPON) {
            return "COUPON";
        }
        throw new UnsupportedOperationException("\u4ee3\u7801\u672a\u5b9e\u73b0'\u901a\u5546\u4e91'\u652f\u4ed8\u7c7b\u578b\u8f6c\u6362:" + payType.getName());
    }

    protected OrderGenerator acquireOrderGenerator(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        return this.orderGeneratorMap.get(providerPayType);
    }

    protected boolean verifySign(Object notifyData) throws Exception {
        RequestNotify requestNotify = (RequestNotify)((Object)notifyData);
        String signedValue = requestNotify.toSignSource();
        this.logger.debug(signedValue);
        return this.sdkClient.checkSign(signedValue, requestNotify.getSign());
    }

    protected PayContext acquirePayContext(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        CloudPayContext context = new CloudPayContext();
        return context;
    }

    protected OrderStatusQuery acquireOrderStatusQuery(Order order) {
        OrderStatusQuery orderStatusQuery = new OrderStatusQuery();
        orderStatusQuery.setOrderId(order.getId());
        return orderStatusQuery;
    }

    protected OrderStatusResponsePay invokeOrderStatus(OrderStatusQuery orderStatusQuery) {
        return this.sdkClient.searchOrderStatus(String.valueOf(orderStatusQuery.getOrderId()));
    }

    public String generateNotifyResponse(boolean success) {
        return "OK";
    }

    public void setConfiguration(Map<String, Variable> configuration) {
        super.setConfiguration(configuration);
        OpenConfig openConfig = new OpenConfig();
        openConfig.setUrl(configuration.get("PAY.ALLINPAY_CLOUD.URL").getStringValue());
        openConfig.setAppId(configuration.get("PAY.ALLINPAY_CLOUD.APPID").getStringValue());
        openConfig.setSecretKey(configuration.get("PAY.ALLINPAY_CLOUD.SECRET_KEY").getStringValue());
        openConfig.setCertPath(configuration.get("PAY.ALLINPAY_CLOUD.PRIVATE_KEY_PATH").getStringValue());
        openConfig.setCertPwd(configuration.get("PAY.ALLINPAY_CLOUD.PWD").getStringValue());
        openConfig.setTlCertPath(configuration.get("PAY.ALLINPAY_CLOUD.PUBLIC_KEY").getStringValue());
        this.sdkClient = new SdkClient(openConfig);
        this.init();
        this.logger.info("SdkClient create...");
    }

    private void init() {
        this.setServiceProvider(ServiceProvider.AllinPayCloud);
        this.setVersion("v1");
        this.setPayChannel(PayChannel.ProviderDirect);
        if (this.sdkClient == null) {
            throw new IllegalArgumentException("SdkClient \u672a\u521b\u5efa\uff0c\u65e0\u6cd5\u6784\u5efa\u652f\u4ed8\u5f15\u64ce:" + ((Object)((Object)this)).getClass().getName());
        }
        BankCardOrderGenerator bankCardOrderGenerator = new BankCardOrderGenerator();
        bankCardOrderGenerator.setSdkClient(this.sdkClient);
        WechatJsOrderGenerator wechatJsOrderGenerator = new WechatJsOrderGenerator();
        wechatJsOrderGenerator.setSdkClient(this.sdkClient);
        WechatProgramOrderGenerator wechatProgramOrderGenerator = new WechatProgramOrderGenerator();
        wechatProgramOrderGenerator.setSdkClient(this.sdkClient);
        ScanWechatOrderGenerator scanWechatOrderGenerator = new ScanWechatOrderGenerator();
        scanWechatOrderGenerator.setSdkClient(this.sdkClient);
        this.orderGeneratorMap.put("QUICKPAY_VSP", (OrderGenerator)bankCardOrderGenerator);
        this.orderGeneratorMap.put("WECHAT_PUBLIC", (OrderGenerator)wechatJsOrderGenerator);
        this.orderGeneratorMap.put("WECHATPAY_MINIPROGRAM", (OrderGenerator)wechatProgramOrderGenerator);
        this.orderGeneratorMap.put("SCAN_WEIXIN", (OrderGenerator)scanWechatOrderGenerator);
    }

    public SdkClient getSdkClient() {
        return this.sdkClient;
    }
}

