/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpaycloud;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Convertor;
import com.walker.pay.NotifyValue;
import com.walker.pay.ServiceProvider;
import com.walker.pay.allinpaycloud.NotifyOrder;
import com.walker.pay.allinpaycloud.RequestNotify;
import com.walker.pay.allinpaycloud.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyOrderConvertor
implements Convertor<NotifyValue<?>> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public NotifyValue<Object> toGenericObject(Object data) {
        if (!(data instanceof RequestNotify)) {
            throw new IllegalArgumentException("\u901a\u77e5\u7c7b\u578b\u5fc5\u987b\u662f'RequestNotify'");
        }
        RequestNotify requestNotify = (RequestNotify)((Object)data);
        if (StringUtils.isEmpty((String)requestNotify.getBizContent())) {
            throw new IllegalArgumentException("\u901a\u5546\u4e91\u652f\u4ed8\u901a\u77e5\uff0c\u672a\u63a5\u6536\u5230 bizContent \u4e1a\u52a1\u6570\u636e:" + requestNotify, null);
        }
        String decodeBizContent = TextUtils.decodeFormUrlParameter(requestNotify.getBizContent());
        this.logger.debug(decodeBizContent);
        NotifyValue notifyValue = new NotifyValue();
        notifyValue.setId(requestNotify.getNotifyId());
        notifyValue.setSource(data);
        notifyValue.setCreateTime(requestNotify.getNotifyTime());
        notifyValue.setDataType(requestNotify.getNotifyType());
        try {
            NotifyOrder notifyOrder = (NotifyOrder)JsonUtils.jsonStringToObject((String)decodeBizContent, NotifyOrder.class);
            notifyValue.setBuyerId(notifyOrder.getBuyerBizUserId());
            notifyValue.setOrderId(notifyOrder.getBizOrderNo());
            notifyValue.setTradeNo(notifyOrder.getOrderNo());
            notifyValue.setServiceProvider(ServiceProvider.AllinPayCloud);
            String payStatusValue = notifyOrder.getStatus();
            if (payStatusValue.equals("OK")) {
                this.logger.debug("\u901a\u77e5\u652f\u4ed8\u6210\u529f: " + notifyOrder);
                notifyValue.setStatus(true);
            }
            notifyValue.setData((Object)notifyOrder);
            return notifyValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

