/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpaycloud;

import com.allinpay.sdk.OpenClient;
import com.allinpay.sdk.bean.BizParameter;
import com.allinpay.sdk.bean.OpenConfig;
import com.allinpay.sdk.bean.OpenResponse;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.ResponsePay;
import com.walker.pay.allinpaycloud.SdkException;
import com.walker.pay.allinpaycloud.WithdrawOrder;
import com.walker.pay.allinpaycloud.pojo.BankCardInfo;
import com.walker.pay.allinpaycloud.pojo.MemberEnterprise;
import com.walker.pay.allinpaycloud.pojo.MemberPerson;
import com.walker.pay.allinpaycloud.pojo.RequestApplyBindBankCard;
import com.walker.pay.allinpaycloud.pojo.RequestBalance;
import com.walker.pay.allinpaycloud.pojo.RequestBindAcct;
import com.walker.pay.allinpaycloud.pojo.RequestBindBankCard;
import com.walker.pay.allinpaycloud.pojo.RequestBindPhone;
import com.walker.pay.allinpaycloud.pojo.RequestConfirmPay;
import com.walker.pay.allinpaycloud.pojo.RequestMember;
import com.walker.pay.allinpaycloud.pojo.RequestRealName;
import com.walker.pay.allinpaycloud.pojo.RequestSendVerifyCode;
import com.walker.pay.allinpaycloud.pojo.RequestSetCompany;
import com.walker.pay.allinpaycloud.pojo.RequestSignAcct;
import com.walker.pay.allinpaycloud.pojo.RequestSignContractQuery;
import com.walker.pay.allinpaycloud.pojo.RequestUnbindBankCard;
import com.walker.pay.allinpaycloud.pojo.RequestUploadGather;
import com.walker.pay.allinpaycloud.pojo.ResponseApplyBindBankCard;
import com.walker.pay.allinpaycloud.pojo.ResponseBalance;
import com.walker.pay.allinpaycloud.pojo.ResponseBindAcct;
import com.walker.pay.allinpaycloud.pojo.ResponseBindBankCard;
import com.walker.pay.allinpaycloud.pojo.ResponseBindPhone;
import com.walker.pay.allinpaycloud.pojo.ResponseCardBinInfo;
import com.walker.pay.allinpaycloud.pojo.ResponseConfirmPay;
import com.walker.pay.allinpaycloud.pojo.ResponseMember;
import com.walker.pay.allinpaycloud.pojo.ResponseMemberInfo;
import com.walker.pay.allinpaycloud.pojo.ResponseRealName;
import com.walker.pay.allinpaycloud.pojo.ResponseSetCompany;
import com.walker.pay.allinpaycloud.pojo.ResponseUnBindPhone;
import com.walker.pay.allinpaycloud.pojo.ResponseUnbindBankCard;
import com.walker.pay.allinpaycloud.pojo.ResponseUploadGather;
import com.walker.pay.allinpaycloud.pojo.ResponseWithdraw;
import com.walker.pay.allinpaycloud.util.MemberUtils;
import com.walker.pay.allinpaycloud.util.OrderUtils;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.support.BankCardOrder;
import com.walker.pay.support.allinpaycloud.AlipayServiceOrder;
import com.walker.pay.support.allinpaycloud.CouponOrder;
import com.walker.pay.support.allinpaycloud.ScanWechatOrder;
import com.walker.pay.support.allinpaycloud.WechatJsOrder;
import com.walker.pay.support.allinpaycloud.WechatMiniProgramOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkClient {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private OpenConfig openConfig = null;
    private OpenClient openClient = null;
    private KeyValue<String, String> industryInfo = new KeyValue((Object)"2422", (Object)"\u5176\u4ed6");

    public SdkClient(OpenConfig openConfig) {
        if (openConfig == null) {
            throw new IllegalArgumentException("OpenConfig \u5fc5\u987b\u63d0\u4f9b!");
        }
        this.openConfig = openConfig;
        this.createOpenClient();
    }

    public OpenClient getOpenClient() {
        return this.openClient;
    }

    public boolean checkSign(String signedValue, String sign) {
        return this.openClient.checkSign(signedValue, sign);
    }

    public OpenResponse consumeApply(Order order) {
        BizParameter param = new BizParameter();
        param.put((Object)"payerId", (Object)order.getBuyerId());
        param.put((Object)"recieverId", (Object)order.getReceiverId());
        param.put((Object)"bizOrderNo", (Object)order.getIdString());
        param.put((Object)"amount", (Object)order.getTotalMoney());
        param.put((Object)"fee", (Object)order.getFee());
        param.put((Object)"validateType", (Object)0L);
        List splitAccountList = order.getSplitAccountList();
        if (!StringUtils.isEmptyList((List)splitAccountList)) {
            Object splitAccountJsonArray = OrderUtils.acquireSplitAccountParam(splitAccountList);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(splitAccountJsonArray.toString());
            }
            param.put((Object)"splitRule", splitAccountJsonArray);
        }
        param.put((Object)"backUrl", (Object)order.getNotifyUrl());
        param.put((Object)"orderExpireDatetime", (Object)OrderUtils.getOrderExpireDateTime());
        param.put((Object)"goodsName", (Object)order.getTitle());
        param.put((Object)"industryCode", this.industryInfo.getKey());
        param.put((Object)"industryName", this.industryInfo.getValue());
        param.put((Object)"source", (Object)1L);
        param.put((Object)"extendInfo", (Object)order.getAttach());
        HashMap<String, Object> payMethod = null;
        if (order instanceof BankCardOrder) {
            BankCardOrder bankCardOrder = (BankCardOrder)order;
            payMethod = OrderUtils.getBankCardPayMethod(this.openClient.encrypt(bankCardOrder.getBankCardNo()), order.getTotalMoney());
        } else if (order instanceof WechatMiniProgramOrder) {
            WechatMiniProgramOrder wechatJsOrder = (WechatMiniProgramOrder)order;
            payMethod = OrderUtils.getWechatJsPayMethod(wechatJsOrder.getAcct(), wechatJsOrder.getTotalMoney(), wechatJsOrder.getLimitPay(), wechatJsOrder.getIdNo(), wechatJsOrder.getName(), wechatJsOrder.getSubAppid(), true);
        } else if (order instanceof WechatJsOrder) {
            WechatJsOrder wechatJsOrder = (WechatJsOrder)order;
            payMethod = OrderUtils.getWechatJsPayMethod(wechatJsOrder.getAcct(), wechatJsOrder.getTotalMoney(), wechatJsOrder.getLimitPay(), wechatJsOrder.getIdNo(), wechatJsOrder.getName(), wechatJsOrder.getSubAppid(), false);
        } else if (order instanceof AlipayServiceOrder) {
            AlipayServiceOrder alipayServiceOrder = (AlipayServiceOrder)order;
            payMethod = OrderUtils.getAlipayJsPayMethod(alipayServiceOrder.getAcct(), alipayServiceOrder.getTotalMoney(), alipayServiceOrder.getLimitPay(), alipayServiceOrder.getIdNo(), alipayServiceOrder.getName());
        } else if (order instanceof CouponOrder) {
            CouponOrder couponOrder = (CouponOrder)order;
            payMethod = OrderUtils.getCouponPayMethod(couponOrder.getAccountSetNo(), couponOrder.getTotalMoney());
        } else if (order instanceof ScanWechatOrder) {
            ScanWechatOrder scanWechatOrder = (ScanWechatOrder)order;
            payMethod = OrderUtils.getScanWechatPayMethod(scanWechatOrder);
        } else {
            throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u4ee3\u7801!");
        }
        param.put((Object)"payMethod", payMethod);
        return this.openClient.execute("allinpay.yunst.orderService.consumeApply", param);
    }

    public String getSignAcctProtocolParams(RequestSignAcct requestSignAcct) {
        BizParameter param = new BizParameter();
        param.put((Object)"bizUserId", (Object)requestSignAcct.getBizUserId());
        param.put((Object)"signAcctName", (Object)requestSignAcct.getSignAcctName());
        param.put((Object)"jumpUrl", (Object)requestSignAcct.getJumpUrl());
        param.put((Object)"backUrl", (Object)requestSignAcct.getBackUrl());
        param.put((Object)"jumpPageType", (Object)requestSignAcct.getJumpPageType());
        param.put((Object)"source", (Object)requestSignAcct.getSource());
        return this.openClient.concatUrlParams("allinpay.yunst.memberService.signAcctProtocol", param);
    }

    public ResponseBalance queryBalance(RequestBalance requestBalance) {
        BizParameter param = new BizParameter();
        param.put((Object)"bizUserId", (Object)requestBalance.getBizUserId());
        param.put((Object)"accountSetNo", (Object)requestBalance.getAccountSetNo());
        OpenResponse response = this.openClient.execute("allinpay.yunst.orderService.queryBalance", param);
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u67e5\u8be2\u4f59\u989d'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseBalance)ResponsePay.error(ResponseBalance.class, (String)error);
        }
        try {
            return (ResponseBalance)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseBalance.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u67e5\u8be2\u4f59\u989d'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public OrderStatusResponsePay searchOrderStatus(String bizOrderNo) {
        BizParameter param = new BizParameter();
        param.put((Object)"bizOrderNo", (Object)bizOrderNo);
        OpenResponse response = this.openClient.execute("allinpay.yunst.orderService.getOrderStatus", param);
        OrderStatusResponsePay orderStatusResponsePay = new OrderStatusResponsePay();
        if (response == null || !"OK".equals(response.getSubCode())) {
            String msg = response == null ? "" : response.getSubMsg();
            this.logger.error("\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u9519\u8bef\uff0cmsg = {}", (Object)msg);
            orderStatusResponsePay.setStatus(false);
            orderStatusResponsePay.setMessage(msg);
            return orderStatusResponsePay;
        }
        try {
            ObjectNode info = JsonUtils.jsonStringToObjectNode((String)response.getData());
            return OrderUtils.obtainOrderStatusResponsePay(info, orderStatusResponsePay);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u67e5\u8be2\u8ba2\u5355\u72b6\u6001'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseWithdraw withdrawApply(WithdrawOrder order) {
        BizParameter param = new BizParameter();
        param.put((Object)"bizUserId", (Object)order.getBuyerId());
        param.put((Object)"bizOrderNo", (Object)order.getIdString());
        param.put((Object)"accountSetNo", (Object)order.getAccountSetNo());
        param.put((Object)"amount", (Object)order.getTotalMoney());
        param.put((Object)"fee", (Object)order.getFee());
        param.put((Object)"validateType", (Object)0L);
        param.put((Object)"backUrl", (Object)order.getNotifyUrl());
        param.put((Object)"orderExpireDatetime", (Object)OrderUtils.getOrderExpireDateTime());
        param.put((Object)"bankCardNo", (Object)this.openClient.encrypt(order.getBankCardNo()));
        param.put((Object)"bankCardPro", (Object)order.getBankCardPro());
        param.put((Object)"withdrawType", (Object)order.getWithdrawType());
        param.put((Object)"industryCode", this.industryInfo.getKey());
        param.put((Object)"industryName", this.industryInfo.getValue());
        param.put((Object)"source", (Object)1L);
        param.put((Object)"extendInfo", (Object)order.getAttach());
        OpenResponse response = this.openClient.execute("allinpay.yunst.orderService.withdrawApply", param);
        if (response == null) {
            throw new RuntimeException("\u8c03\u7528'\u901a\u5546\u4e91'\u63d0\u73b0\u7533\u8bf7\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + order.getId());
        }
        if (!"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u63d0\u73b0\u7533\u8bf7'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseWithdraw)ResponsePay.error(ResponseWithdraw.class, (String)error);
        }
        try {
            return (ResponseWithdraw)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseWithdraw.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u63d0\u73b0\u7533\u8bf7'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseCardBinInfo getCardBinInfo(String cardNo) {
        BizParameter param = new BizParameter();
        param.put((Object)"cardNo", (Object)this.openClient.encrypt(cardNo));
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.getBankCardBin", param);
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'carBin\u67e5\u8be2'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseCardBinInfo)ResponsePay.error(ResponseCardBinInfo.class, (String)error);
        }
        try {
            ObjectNode info = JsonUtils.jsonStringToObjectNode((String)response.getData());
            String cardBinInfo = info.get("cardBinInfo").toString();
            return (ResponseCardBinInfo)((Object)JsonUtils.jsonStringToObject((String)cardBinInfo, ResponseCardBinInfo.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'carBin\u67e5\u8be2'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseMemberInfo getMemberInfo(String bizUserId) {
        BizParameter param = new BizParameter();
        param.put((Object)"bizUserId", (Object)bizUserId);
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.getMemberInfo", param);
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u67e5\u8be2\u4f1a\u5458'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseMemberInfo)ResponsePay.error(ResponseMemberInfo.class, (String)error);
        }
        try {
            ObjectNode info = JsonUtils.jsonStringToObjectNode((String)response.getData());
            ResponseMemberInfo responseMemberInfo = new ResponseMemberInfo();
            String memberInfo = info.get("memberInfo").toString();
            System.out.println(memberInfo);
            if (info.get("memberType").asLong() == 3L) {
                MemberPerson memberPerson = ResponseMemberInfo.toMemberPerson(memberInfo);
                responseMemberInfo.setMemberPerson(memberPerson);
            } else {
                MemberEnterprise memberEnterprise = ResponseMemberInfo.toMemberEnterprise(memberInfo);
                responseMemberInfo.setMemberEnterprise(memberEnterprise);
            }
            return responseMemberInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u67e5\u8be2\u4f1a\u5458'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public String signContractQuery(RequestSignContractQuery request) throws SdkException {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.signContractQuery", MemberUtils.acquireSignContractQuery(request));
        if (response == null) {
            throw new SdkException("", "\u7b7e\u7ea6\u67e5\u8be2\u9519\u8bef", null);
        }
        if (response.getCode().equals("10000")) {
            return response.getData();
        }
        this.logger.error(response.getMsg());
        return null;
    }

    public ResponseConfirmPay confirmPay(RequestConfirmPay request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.orderService.payByBackSMS", MemberUtils.acquireConfirmPay(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u652f\u4ed8\u786e\u8ba4\uff08\u77ed\u4fe1\u9a8c\u8bc1\uff09'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseConfirmPay)ResponsePay.error(ResponseConfirmPay.class, (String)error);
        }
        try {
            return (ResponseConfirmPay)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseConfirmPay.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u652f\u4ed8\u786e\u8ba4\uff08\u77ed\u4fe1\u9a8c\u8bc1\uff09'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseUploadGather uploadGather(RequestUploadGather request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.idcardCollect", MemberUtils.acquireUploadGather(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u5f71\u97f3\u91c7\u96c6'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseUploadGather)ResponsePay.error(ResponseUploadGather.class, (String)error);
        }
        try {
            return (ResponseUploadGather)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseUploadGather.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u5f71\u97f3\u91c7\u96c6'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseSetCompany setCompany(RequestSetCompany request) {
        request.setLegalIds(this.openClient.encrypt(request.getLegalIds()));
        request.setAccountNo(this.openClient.encrypt(request.getAccountNo()));
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.setCompanyInfo", MemberUtils.acquireSetCompany(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u8bbe\u7f6e\u4f01\u4e1a'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseSetCompany)ResponsePay.error(ResponseSetCompany.class, (String)error);
        }
        try {
            return (ResponseSetCompany)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseSetCompany.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u8bbe\u7f6e\u4f01\u4e1a'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseBindPhone bindPhone(RequestBindPhone request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.bindPhone", MemberUtils.acquireBindPhone(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("\u7ed1\u5b9a\u624b\u673a\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseBindPhone)ResponsePay.error(ResponseBindPhone.class, (String)error);
        }
        try {
            return (ResponseBindPhone)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseBindPhone.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u7ed1\u5b9a\u624b\u673a'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseUnBindPhone unbindPhone(RequestBindPhone request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.unbindPhone", MemberUtils.acquireBindPhone(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u89e3\u7ed1\u624b\u673a'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseUnBindPhone)ResponsePay.error(ResponseUnBindPhone.class, (String)error);
        }
        try {
            return (ResponseUnBindPhone)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseUnBindPhone.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u89e3\u7ed1\u624b\u673a'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseBindPhone sendVerifyCode(RequestSendVerifyCode request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.sendVerificationCode", MemberUtils.acquireSendVerifyCode(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u7ed1\u5b9a\u624b\u673a(\u53d1\u9001\u9a8c\u8bc1\u7801)'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseBindPhone)ResponsePay.error(ResponseBindPhone.class, (String)error);
        }
        try {
            return (ResponseBindPhone)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseBindPhone.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u7ed1\u5b9a\u624b\u673a(\u53d1\u9001\u9a8c\u8bc1\u7801)'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseUnbindBankCard unbindBankCard(RequestUnbindBankCard request) {
        request.setCardNo(this.openClient.encrypt(request.getCardNo()));
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.unbindBankCard", MemberUtils.acquireUnbindBankCard(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u89e3\u9664\u7ed1\u5b9a\u94f6\u884c\u5361'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseUnbindBankCard)ResponsePay.error(ResponseUnbindBankCard.class, (String)error);
        }
        try {
            return (ResponseUnbindBankCard)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseUnbindBankCard.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u89e3\u9664\u7ed1\u5b9a\u94f6\u884c\u5361'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public List<BankCardInfo> getBindCardList(String bizUserId, String cardNo) throws SdkException {
        OpenResponse response;
        BizParameter param = new BizParameter();
        param.put((Object)"bizUserId", (Object)bizUserId);
        if (StringUtils.isNotEmpty((String)cardNo)) {
            param.put((Object)"cardNo", (Object)this.openClient.encrypt(cardNo));
        }
        if ((response = this.openClient.execute("allinpay.yunst.memberService.queryBankCard", param)) == null || !"OK".equals(response.getSubCode())) {
            this.logger.error("'\u67e5\u8be2\u7ed1\u5361'\u9519\u8bef\uff0cmsg = {}", (Object)(response == null ? "" : response.getSubMsg()));
            throw new SdkException(response.getSubMsg(), "\u67e5\u8be2\u7ed1\u5361\u8c03\u7528sdk\u9519\u8bef", null);
        }
        try {
            ObjectNode info = JsonUtils.jsonStringToObjectNode((String)response.getData());
            String cardListInfo = info.get("bindCardList").toString();
            ArrayNode arrayNode = JsonUtils.toJsonArray((String)cardListInfo);
            if (arrayNode == null || arrayNode.size() <= 0) {
                return null;
            }
            ArrayList<BankCardInfo> bankCardInfos = new ArrayList<BankCardInfo>(4);
            String one = null;
            BankCardInfo bankCardInfo = null;
            for (int i = 0; i < arrayNode.size(); ++i) {
                one = arrayNode.get(i).toString();
                bankCardInfo = (BankCardInfo)JsonUtils.jsonStringToObject((String)one, BankCardInfo.class);
                bankCardInfo.setBankCardNo(this.openClient.decrypt(bankCardInfo.getBankCardNo()));
                bankCardInfos.add(bankCardInfo);
            }
            return bankCardInfos;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u67e5\u8be2\u7ed1\u5361'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseBindBankCard bindBankCard(RequestBindBankCard request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.bindBankCard", MemberUtils.acquireBindBankCard(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u786e\u8ba4\u7ed1\u5b9a\u94f6\u884c\u5361'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseBindBankCard)ResponsePay.error(ResponseBindBankCard.class, (String)error);
        }
        try {
            return (ResponseBindBankCard)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseBindBankCard.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u7ed1\u5b9a\u94f6\u884c\u5361'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseApplyBindBankCard applyBindBankCard(RequestApplyBindBankCard request) {
        request.setCardNo(this.openClient.encrypt(request.getCardNo()));
        request.setIdentityNo(this.openClient.encrypt(request.getIdentityNo()));
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.applyBindBankCard", MemberUtils.acquireApplyBindBankCard(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u7ed1\u5b9a\u94f6\u884c\u5361'\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseApplyBindBankCard)ResponsePay.error(ResponseApplyBindBankCard.class, (String)error);
        }
        try {
            return (ResponseApplyBindBankCard)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseApplyBindBankCard.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362'\u7ed1\u5b9a\u94f6\u884c\u5361'json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseBindAcct bindAcct(RequestBindAcct request) {
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.applyBindAcct", MemberUtils.acquireBindAcct(request));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("'\u7ed1\u5b9a\u652f\u4ed8\u6807\u8bc6'\u4f1a\u5458\u5b9e\u540d\u8ba4\u8bc1''\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseBindAcct)ResponsePay.error(ResponseBindAcct.class, (String)error);
        }
        try {
            return (ResponseBindAcct)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseBindAcct.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u7ed1\u5b9a\u652f\u4ed8\u6807\u8bc6json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseRealName setRealName(RequestRealName requestRealName) {
        String cardNo = requestRealName.getIdentityNo();
        if (StringUtils.isEmpty((String)cardNo)) {
            throw new IllegalArgumentException("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u7a7a!");
        }
        requestRealName.setIdentityNo(this.openClient.encrypt(cardNo));
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.setRealName", MemberUtils.acquireRealName(requestRealName));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("\u4f1a\u5458\u5b9e\u540d\u8ba4\u8bc1\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseRealName)ResponsePay.error(ResponseRealName.class, (String)error);
        }
        try {
            return (ResponseRealName)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseRealName.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u5b9e\u540d\u8ba4\u8bc1json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    public ResponseMember createMember(RequestMember requestMember) {
        if (StringUtils.isEmpty((String)requestMember.getBizUserId())) {
            throw new IllegalArgumentException("bizUserId \u5fc5\u987b\u8bbe\u7f6e!");
        }
        OpenResponse response = this.openClient.execute("allinpay.yunst.memberService.createMember", MemberUtils.acquireCreateMember(requestMember));
        if (response == null || !"OK".equals(response.getSubCode())) {
            String error = response == null ? "" : response.getSubMsg();
            this.logger.error("\u521b\u5efa\u4f1a\u5458\u9519\u8bef\uff0cmsg = {}", (Object)error);
            return (ResponseMember)ResponsePay.error(ResponseMember.class, (String)error);
        }
        try {
            return (ResponseMember)((Object)JsonUtils.jsonStringToObject((String)response.getData(), ResponseMember.class));
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u4f1a\u5458json\u9519\u8bef:" + e.getMessage(), e);
        }
    }

    private void createOpenClient() {
        if (this.openClient != null) {
            this.logger.warn("OpenClient \u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u521b\u5efa!");
            return;
        }
        try {
            this.openClient = new OpenClient(this.openConfig);
            this.logger.debug("\u521b\u5efa 'OpenClient' \u4e00\u6b21.");
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa 'OpenClient' \u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setIndustryInfo(KeyValue<String, String> industryInfo) {
        this.industryInfo = industryInfo;
    }
}

