/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpaycloud.generator;

import com.allinpay.sdk.bean.OpenResponse;
import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.allinpaycloud.BaseOrderGenerator;
import com.walker.pay.allinpaycloud.generator.OrderResponsePay;
import com.walker.pay.allinpaycloud.util.OrderUtils;
import com.walker.pay.response.ScanOrderResponsePay;
import com.walker.pay.support.allinpaycloud.ScanWechatOrder;
import java.util.Map;

public class ScanWechatOrderGenerator
extends BaseOrderGenerator {
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        this.checkSdkClient();
        if (!(platformOrder instanceof ScanWechatOrder)) {
            throw new IllegalArgumentException("\u5fae\u4fe1\u626b\u63cf\uff08\u6b63\u626b\uff09\u652f\u4ed8\u8ba2\u5355\u7c7b\u578b\u5fc5\u987b\u662f'ScanWechatOrder'");
        }
        OpenResponse response = this.getSdkClient().consumeApply(platformOrder);
        if (response == null) {
            throw new RuntimeException("\u8c03\u7528'\u901a\u5546\u4e91\u5fae\u4fe1\u626b\u7801'\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + platformOrder.getId());
        }
        if (!"OK".equals(response.getSubCode())) {
            this.logger.debug("'\u5fae\u4fe1\u626b\u7801\uff08\u6b63\u626b\uff09'\u8ba2\u5355\u8fd4\u56de\u5931\u8d25:{}", (Object)response.getSubMsg());
            return ResponsePay.error(ScanOrderResponsePay.class, (String)response.getSubMsg());
        }
        ScanOrderResponsePay scanOrderResponsePay = new ScanOrderResponsePay();
        try {
            OrderResponsePay responseValue = OrderUtils.getOrderResponsePay(response.getData());
            if (responseValue == null) {
                throw new RuntimeException("orderResponsePay = null!");
            }
            scanOrderResponsePay.setStatus(true);
            scanOrderResponsePay.setCodeUrl(responseValue.getPayInfo());
            return scanOrderResponsePay;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u8c03\u7528'\u901a\u5546\u4e91\u5fae\u4fe1\u626b\u7801\uff08\u6b63\u626b\uff09'\u8ba2\u5355\u6570\u636e\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25, orderId = " + platformOrder.getId());
        }
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        return null;
    }
}

