/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpaycloud.generator;

import com.allinpay.sdk.bean.OpenResponse;
import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.allinpaycloud.BaseOrderGenerator;
import com.walker.pay.allinpaycloud.generator.OrderResponsePay;
import com.walker.pay.allinpaycloud.util.OrderUtils;
import java.util.Map;

public class WechatJsOrderGenerator
extends BaseOrderGenerator {
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        this.checkSdkClient();
        OpenResponse response = this.getSdkClient().consumeApply(platformOrder);
        if (response == null) {
            throw new RuntimeException("\u8c03\u7528'\u901a\u5546\u4e91'\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + platformOrder.getId());
        }
        OrderResponsePay responseValue = new OrderResponsePay();
        if (!"OK".equals(response.getSubCode())) {
            responseValue.setStatus(false);
            responseValue.setMessage(response.getSubMsg());
            this.logger.debug("'\u5fae\u4fe1js\u652f\u4ed8'\u8ba2\u5355\u8fd4\u56de\u5931\u8d25:{}", (Object)response.getSubMsg());
            return responseValue;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(response.getData());
        }
        try {
            responseValue = OrderUtils.getOrderResponsePay(response.getData());
            if (responseValue == null) {
                throw new RuntimeException("orderResponsePay = null!");
            }
            return responseValue;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u8c03\u7528'\u901a\u5546\u4e91'\u8ba2\u5355\u6570\u636e\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25, orderId = " + platformOrder.getId());
        }
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        return null;
    }
}

