/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.allinpaycloud.util;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.PayStatus;
import com.walker.pay.SplitAccount;
import com.walker.pay.allinpaycloud.generator.OrderResponsePay;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.support.allinpaycloud.ScanWechatOrder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class OrderUtils {
    public static final SplitAccount acquireSplitAccount(String bizUserId, long amount, String remark, long fee, String accountSetNo) {
        SplitAccount splitAccount = new SplitAccount();
        splitAccount.setBizUserId(bizUserId);
        splitAccount.setAmount(Long.valueOf(amount));
        splitAccount.setRemark(remark);
        splitAccount.setFee(Long.valueOf(fee));
        splitAccount.setAccountSetNo(accountSetNo);
        return splitAccount;
    }

    public static final Object acquireSplitAccountParam(List<SplitAccount> splitAccountList) {
        JSONArray splitRule = new JSONArray();
        if (!StringUtils.isEmptyList(splitAccountList)) {
            for (SplitAccount splitAccount : splitAccountList) {
                HashMap<String, Object> splitRule1 = new HashMap<String, Object>();
                splitRule1.put("bizUserId", splitAccount.getBizUserId());
                if (StringUtils.isEmpty((String)splitAccount.getAccountSetNo())) {
                    splitRule1.put("accountSetNo", "");
                } else {
                    splitRule1.put("accountSetNo", splitAccount.getAccountSetNo());
                }
                splitRule1.put("amount", splitAccount.getAmount());
                splitRule1.put("fee", splitAccount.getFee());
                splitRule1.put("remark", splitAccount.getRemark());
                splitRule.add(splitRule1);
            }
        }
        return splitRule;
    }

    public static final OrderStatusResponsePay obtainOrderStatusResponsePay(ObjectNode info, OrderStatusResponsePay orderStatusResponsePay) {
        long orderStatus;
        orderStatusResponsePay.setOrderId(info.get("bizOrderNo").textValue());
        orderStatusResponsePay.setTradeNo(info.get("orderNo").textValue());
        orderStatusResponsePay.setTotalMoney(info.get("amount").asLong());
        orderStatusResponsePay.setUserPayMoney(orderStatusResponsePay.getTotalMoney());
        if (info.has("payDatetime")) {
            orderStatusResponsePay.setPaySuccessTime(info.get("payDatetime").textValue());
        }
        if ((orderStatus = info.get("orderStatus").asLong()) == 1L) {
            orderStatusResponsePay.setPayStatus(PayStatus.NotPay);
        } else if (orderStatus == 3L) {
            orderStatusResponsePay.setPayStatus(PayStatus.Error);
            orderStatusResponsePay.setMessage(info.get("errorMessage").textValue());
        } else if (orderStatus == 4L) {
            orderStatusResponsePay.setPayStatus(PayStatus.Success);
        } else if (orderStatus == 5L) {
            orderStatusResponsePay.setPayStatus(PayStatus.Refund);
        } else if (orderStatus == 6L) {
            orderStatusResponsePay.setPayStatus(PayStatus.Closed);
        } else if (orderStatus == 99L) {
            orderStatusResponsePay.setPayStatus(PayStatus.Paying);
        } else {
            throw new UnsupportedOperationException("\u672a\u77e5\u8ba2\u5355\u72b6\u6001\uff0c\u901a\u5546\u4e91\u8fd4\u56de:" + orderStatus);
        }
        return orderStatusResponsePay;
    }

    public static final OrderResponsePay getOrderResponsePay(String json) throws Exception {
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        OrderResponsePay orderResponsePay = (OrderResponsePay)((Object)JsonUtils.jsonStringToObject((String)json, OrderResponsePay.class));
        orderResponsePay.setStatus(true);
        return orderResponsePay;
    }

    public static final HashMap<String, Object> getScanWechatPayMethod(ScanWechatOrder order) {
        HashMap<String, Object> quickPay = new HashMap<String, Object>();
        quickPay.put("amount", order.getTotalMoney());
        quickPay.put("extendParams", order.getExtendParams());
        if (StringUtils.isNotEmpty((String)order.getLimitPay())) {
            quickPay.put("limitPay", order.getLimitPay());
        } else {
            quickPay.put("limitPay", "");
        }
        quickPay.put("idNo", order.getIdNo());
        quickPay.put("name", order.getName());
        quickPay.put("certType", order.getCertType());
        HashMap<String, Object> payMethod = new HashMap<String, Object>();
        payMethod.put("SCAN_WEIXIN", quickPay);
        return payMethod;
    }

    public static final HashMap<String, Object> getBankCardPayMethod(String bankCardNo, long amount) {
        HashMap<String, Object> quickPay = new HashMap<String, Object>();
        quickPay.put("bankCardNo", bankCardNo);
        quickPay.put("amount", amount);
        HashMap<String, Object> payMethod = new HashMap<String, Object>();
        payMethod.put("QUICKPAY_VSP", quickPay);
        return payMethod;
    }

    public static final HashMap<String, Object> getCouponPayMethod(String accountSetNo, long amount) {
        HashMap<String, Object> quickPay = new HashMap<String, Object>();
        quickPay.put("accountSetNo", accountSetNo);
        quickPay.put("amount", amount);
        HashMap<String, Object> payMethod = new HashMap<String, Object>();
        payMethod.put("COUPON", quickPay);
        return payMethod;
    }

    public static final HashMap<String, Object> getAlipayJsPayMethod(String acct, long amount, String limitPay, String idNo, String name) {
        HashMap<String, Object> quickPay = new HashMap<String, Object>();
        quickPay.put("acct", acct);
        quickPay.put("amount", amount);
        if (StringUtils.isNotEmpty((String)limitPay)) {
            quickPay.put("limitPay", limitPay);
        } else {
            quickPay.put("limitPay", "");
        }
        if (StringUtils.isNotEmpty((String)idNo)) {
            quickPay.put("idNo", idNo);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            quickPay.put("name", name);
        }
        HashMap<String, Object> payMethod = new HashMap<String, Object>();
        payMethod.put("ALIPAY_SERVICE", quickPay);
        return payMethod;
    }

    public static final HashMap<String, Object> getWechatJsPayMethod(String acct, long amount, String limitPay, String idNo, String name, String subAppid, boolean wechatMiniProgram) {
        HashMap<String, Object> quickPay = new HashMap<String, Object>();
        quickPay.put("acct", acct);
        quickPay.put("amount", amount);
        if (StringUtils.isNotEmpty((String)limitPay)) {
            quickPay.put("limitPay", limitPay);
        } else {
            quickPay.put("limitPay", "");
        }
        if (StringUtils.isNotEmpty((String)idNo)) {
            quickPay.put("idNo", idNo);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            quickPay.put("name", name);
        }
        if (StringUtils.isNotEmpty((String)subAppid)) {
            quickPay.put("subAppid", subAppid);
        }
        HashMap<String, Object> payMethod = new HashMap<String, Object>();
        if (wechatMiniProgram) {
            payMethod.put("WECHATPAY_MINIPROGRAM", quickPay);
        } else {
            payMethod.put("WECHAT_PUBLIC", quickPay);
        }
        return payMethod;
    }

    public static final String getOrderExpireDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, 15);
        Date date = calendar.getTime();
        return sdf.format(date);
    }
}

