package com.walker.pay.payunk;

import com.fasterxml.jackson.databind.JsonNode;
import com.walker.infrastructure.utils.MoneyUtils;
import com.walker.pay.AbstractOrderGenerator;
import com.walker.pay.Order;
import com.walker.pay.PayException;
import com.walker.pay.payunk.util.AlipayUtils;
import com.walker.pay.payunk.util.SignUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

public abstract class BaseOrderGenerator extends AbstractOrderGenerator {

    protected String sendRequest(String url, Map<String, Object> payMap) throws PayException{
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<Map<String, Object>> request = new HttpEntity<>(payMap, headers);
//        ResponseEntity<String> entity = this.getRestTemplate().postForEntity(url, request, String.class);
        ResponseEntity<JsonNode> entity = this.getRestTemplate().postForEntity(url, request, JsonNode.class);
        logger.debug("entity = {}", entity);
        if(entity.getStatusCodeValue() != 200){
            throw new PayException(payMap.get("out_trade_no").toString(), "调用转账接口失败，" + entity.toString(), null);
        }
        return entity.getBody().toString();
    }

    protected Map<String, Object> toRequest(DefaultPayContext context, Order platformOrder, String payInfo, String providerPayType){
        // 请求封装参数
        Map<String, Object> payMap = new HashMap<>(10);
        // 您的商户唯一标识
        payMap.put("appid", context.getAppIdConfig().getStringValue());
        // 支付通道
//        payMap.put("pay_type", Constants.PAY_TYPE_TRANS_ALIPAY_ONE);
        payMap.put("pay_type", providerPayType);
        // 畅联后台 账户管理 账户编号
        payMap.put("user_account_id", context.getUserAccountId().getStringValue());
        // 交易金额 单位：元 精确小数点后2位10.00
        payMap.put("amount", MoneyUtils.scaleYuan2Accuracy(platformOrder.getTotalMoney()));
        // 回调地址
        payMap.put("callback_url", platformOrder.getNotifyUrl());
        // 商户订单号	C20142222231234
        payMap.put("out_trade_no", String.valueOf(platformOrder.getId()));

//        payMap.put("pay", JsonUtils.objectToJsonString(AlipayUtils.acquireAlipayReplace(context)));
        payMap.put("pay", payInfo);

//        payMap.put("extend", AlipayUtils.getAlipayInfo(platformOrder));
        payMap.put("extend", AlipayUtils.getAlipayInfoExtendJson(platformOrder));

        // sign	签名
        String signStr = SignUtils.signature(payMap);
        payMap.put("sign", signStr);
        return payMap;
    }

    public RestTemplate getRestTemplate() {
        return restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

//    public static final String PAY_RETURN_JSON_URL = "https://apipay.payunk.cn/pay/index/unifiedorder?format=json";
    public static final String PAY_RETURN_JSON_URL = "https://apipay.payunk.cn/pay/index/unifiedorder?format=jsonIn";
    private RestTemplate restTemplate;
}
