package com.walker.pay.payunk;

import com.walker.pay.CallBackException;
import com.walker.pay.NotifyValue;
import com.walker.pay.Order;
import com.walker.pay.PayType;
import com.walker.pay.ResponsePay;
import com.walker.pay.callback.AbstractOrderCallback;

/**
 * 畅联订单回调接口实现。
 * @author 时克英
 * @date 2023-10-27
 */
public class PayUnkOrderCallback extends AbstractOrderCallback {

    @Override
    public void onOrderPrepare(Order platformOrder, ResponsePay responsePay) {
        if(platformOrder.getPayType() == PayType.PayUnk_TRANS_ALIPAY_ONE){
            this.doPrepareOrder(platformOrder, (Trans2AlipayResponsePay) responsePay);

        } else if(platformOrder.getPayType() == PayType.PayUnk_BEHALF_ALIPAY_ONE){
            this.doPrepareOrder(platformOrder, (Trans2AlipayResponsePay) responsePay);

        } else {
            throw new UnsupportedOperationException("[PayUnkOrderCallback]未实现方法: onOrderPrepare(" + platformOrder.getPayType() + ")");
        }
    }

    @Override
    public void onOrderNotify(NotifyValue<?> notifyValue) throws CallBackException {
        throw new UnsupportedOperationException("未写代码");
    }

    protected void doPrepareOrder(Order platformOrder, Trans2AlipayResponsePay responsePay){
        logger.info("默认实现: 执行保存'Trans2AlipayResponsePay'订单操作，order={}", platformOrder);
    }
}
